/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ILoggerSupport;
import io.github.lightman314.lightmanscurrency.api.ItemShopLogger;
import io.github.lightman314.lightmanscurrency.blockentity.ItemInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.item.ItemTradeEditTab;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITradeSource;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.common.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.trader.settings.ItemTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.upgrades.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.upgrades.UpgradeType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullSupplier;

public interface IItemTrader
extends ITrader,
TraderItemStorage.ITraderItemFilter,
UpgradeType.IUpgradeable,
ItemInterfaceBlockEntity.IItemHandlerBlockEntity,
ITradeRuleHandler,
ITradeRuleHandler.ITradeRuleMessageHandler,
ILoggerSupport<ItemShopLogger>,
ITradeSource<ItemTradeData> {
    public static final int DEFAULT_STACK_LIMIT = 576;
    public static final List<UpgradeType> ALLOWED_UPGRADES = Lists.newArrayList((Object[])new UpgradeType[]{UpgradeType.ITEM_CAPACITY});

    @Override
    default public boolean allowUpgrade(UpgradeType type) {
        return ALLOWED_UPGRADES.contains(type);
    }

    public List<ItemTradeData> getAllTrades();

    @Override
    default public int getStorageStackLimit() {
        int limit = 576;
        for (int i = 0; i < this.getUpgradeInventory().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgradeInventory().m_8020_(i);
            if (!(stack.m_41720_() instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)stack.m_41720_()) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            limit += upgradeItem.getDefaultUpgradeData().getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }

    public TraderItemStorage getStorage();

    @Override
    default public boolean isItemRelevant(ItemStack item) {
        for (ItemTradeData trade : this.getAllTrades()) {
            if (!trade.allowItemInStorage(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void markTradesDirty();

    public Container getUpgradeInventory();

    public void markUpgradesDirty();

    public void markStorageDirty();

    default public ItemTradeRestriction getRestriction(int tradeIndex) {
        return ItemTradeRestriction.NONE;
    }

    public ItemTraderSettings getItemSettings();

    public void markItemSettingsDirty();

    public void sendTradeRuleUpdateMessage(int var1, ResourceLocation var2, CompoundTag var3);

    @Override
    default public List<? extends TradeButton.ITradeData> getTradeInfo() {
        return this.getAllTrades();
    }

    @Override
    default public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        ItemTradeData trade = (ItemTradeData)this.getTrade(tradeIndex);
        if (trade == null) {
            LightmansCurrency.LogError("Trade at index " + tradeIndex + " is null. Cannot execute trade!");
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (!trade.isValid()) {
            LightmansCurrency.LogWarning("Trade at index " + tradeIndex + " is not a valid trade. Cannot execute trade.");
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (!context.hasPlayerReference()) {
            return TradeContext.TradeResult.FAIL_NULL;
        }
        if (this.runPreTradeEvent(context.getPlayerReference(), trade).isCanceled()) {
            return TradeContext.TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        CoinValue price = this.runTradeCostEvent(context.getPlayerReference(), trade).getCostResult();
        if (trade.isSale()) {
            if (!trade.hasStock(context) && !this.getCoreSettings().isCreative()) {
                LightmansCurrency.LogDebug("Not enough items in storage to carry out the trade at index " + tradeIndex + ". Cannot execute trade.");
                return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
            }
            if (!context.canFitItems(trade.getSellItem(0), trade.getSellItem(1))) {
                LightmansCurrency.LogInfo("Not enough room for the output item. Aborting trade!");
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.getPayment(price)) {
                LightmansCurrency.LogDebug("Not enough money is present for the trade at index " + tradeIndex + ". Cannot execute trade.");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!context.putItem(trade.getSellItem(0))) {
                LightmansCurrency.LogError("Not enough room for the output item. Giving refund & aborting Trade!");
                context.givePayment(price);
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.putItem(trade.getSellItem(1))) {
                LightmansCurrency.LogError("Not enough room for the output item. Giving refund & aborting Trade!");
                context.collectItem(trade.getSellItem(0));
                context.givePayment(price);
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            ((ItemShopLogger)this.getLogger()).AddLog(context.getPlayerReference(), trade, price, this.getCoreSettings().isCreative());
            this.markLoggerDirty();
            this.getCoreSettings().pushNotification((NonNullSupplier<Notification>)((NonNullSupplier)() -> new ItemTradeNotification(trade, price, context.getPlayerReference(), this.getNotificationCategory())));
            if (!this.getCoreSettings().isCreative()) {
                trade.RemoveItemsFromStorage(this.getStorage());
                this.markStorageDirty();
                this.addStoredMoney(price);
                if (!trade.hasStock(this)) {
                    this.getCoreSettings().pushNotification((NonNullSupplier<Notification>)((NonNullSupplier)() -> new OutOfStockNotification(this.getNotificationCategory(), tradeIndex)));
                }
            }
            this.runPostTradeEvent(context.getPlayerReference(), trade, price);
            return TradeContext.TradeResult.SUCCESS;
        }
        if (trade.isPurchase()) {
            if (!context.hasItems(trade.getSellItem(0), trade.getSellItem(1))) {
                LightmansCurrency.LogDebug("Not enough items in the item slots to make the purchase.");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this) && !this.getCoreSettings().isCreative()) {
                LightmansCurrency.LogDebug("Not enough room in storage to store the purchased items.");
                return TradeContext.TradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (!trade.hasStock(context) && !this.getCoreSettings().isCreative()) {
                LightmansCurrency.LogDebug("Not enough money in storage to pay for the purchased items.");
                return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
            }
            context.collectItem(trade.getSellItem(0));
            context.collectItem(trade.getSellItem(1));
            context.givePayment(price);
            ((ItemShopLogger)this.getLogger()).AddLog(context.getPlayerReference(), trade, price, this.getCoreSettings().isCreative());
            this.markLoggerDirty();
            this.getCoreSettings().pushNotification((NonNullSupplier<Notification>)((NonNullSupplier)() -> new ItemTradeNotification(trade, price, context.getPlayerReference(), this.getNotificationCategory())));
            if (!this.getCoreSettings().isCreative()) {
                this.getStorage().forceAddItem(trade.getSellItem(0));
                this.getStorage().forceAddItem(trade.getSellItem(1));
                this.markStorageDirty();
                this.removeStoredMoney(price);
                if (!trade.hasStock(this)) {
                    this.getCoreSettings().pushNotification((NonNullSupplier<Notification>)((NonNullSupplier)() -> new OutOfStockNotification(this.getNotificationCategory(), tradeIndex)));
                }
            }
            this.runPostTradeEvent(context.getPlayerReference(), trade, price);
            return TradeContext.TradeResult.SUCCESS;
        }
        if (trade.isBarter()) {
            if (!context.hasItems(trade.getBarterItem(0), trade.getBarterItem(1))) {
                LightmansCurrency.LogDebug("Not enough items in the item slots to make the barter.");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this) && !this.getCoreSettings().isCreative()) {
                LightmansCurrency.LogDebug("Not enough room in storage to store the purchased items.");
                return TradeContext.TradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (!trade.hasStock(context) && !this.getCoreSettings().isCreative()) {
                LightmansCurrency.LogDebug("Not enough items in storage to carry out the trade at index " + tradeIndex + ". Cannot execute trade.");
                return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
            }
            context.collectItem(trade.getBarterItem(0));
            context.collectItem(trade.getBarterItem(1));
            if (!context.putItem(trade.getSellItem(0))) {
                LightmansCurrency.LogDebug("Not enough room for the output item. Aborting trade!");
                context.putItem(trade.getBarterItem(0));
                context.putItem(trade.getBarterItem(1));
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.putItem(trade.getSellItem(1))) {
                LightmansCurrency.LogDebug("Not enough room for the output item. Aborting trade!");
                context.collectItem(trade.getSellItem(0));
                context.putItem(trade.getBarterItem(0));
                context.putItem(trade.getBarterItem(1));
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            ((ItemShopLogger)this.getLogger()).AddLog(context.getPlayerReference(), trade, CoinValue.EMPTY, this.getCoreSettings().isCreative());
            this.markLoggerDirty();
            this.getCoreSettings().pushNotification((NonNullSupplier<Notification>)((NonNullSupplier)() -> new ItemTradeNotification(trade, price, context.getPlayerReference(), this.getNotificationCategory())));
            if (!this.getCoreSettings().isCreative()) {
                this.getStorage().forceAddItem(trade.getBarterItem(0));
                this.getStorage().forceAddItem(trade.getBarterItem(1));
                trade.RemoveItemsFromStorage(this.getStorage());
                this.markStorageDirty();
                if (!trade.hasStock(this)) {
                    this.getCoreSettings().pushNotification((NonNullSupplier<Notification>)((NonNullSupplier)() -> new OutOfStockNotification(this.getNotificationCategory(), tradeIndex)));
                }
            }
            this.runPostTradeEvent(context.getPlayerReference(), trade, price);
            return TradeContext.TradeResult.SUCCESS;
        }
        return TradeContext.TradeResult.FAIL_INVALID_TRADE;
    }

    @Override
    default public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(1, new ItemStorageTab(menu));
        menu.setTab(2, new ItemTradeEditTab(menu));
    }
}

