/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.common;

import io.github.lightman314.lightmanscurrency.blockentity.handler.ICanCopy;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.slots.InteractionSlot;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TradeContext {
    public final boolean isStorageMode;
    private final ITrader trader;
    private final Player player;
    private final PlayerReference playerReference;
    private final BankAccount.AccountReference bankAccount;
    private final Container coinSlots;
    private final CoinValue storedMoney;
    private final BiConsumer<CoinValue, Boolean> moneyListener;
    private final InteractionSlot interactionSlot;
    private final IItemHandler itemHandler;
    private final IFluidHandler fluidTank;
    private final IEnergyStorage energyTank;

    public boolean hasTrader() {
        return this.trader != null;
    }

    public ITrader getTrader() {
        return this.trader;
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean hasPlayerReference() {
        return this.playerReference != null;
    }

    public final PlayerReference getPlayerReference() {
        return this.playerReference;
    }

    private boolean hasBankAccount() {
        return this.bankAccount != null && this.bankAccount.get() != null;
    }

    private boolean hasCoinSlots() {
        return this.hasPlayer() && this.coinSlots != null;
    }

    private boolean hasStoredMoney() {
        return this.storedMoney != null;
    }

    private boolean hasInteractionSlot(String type) {
        return this.getInteractionSlot(type) != null;
    }

    private InteractionSlot getInteractionSlot(String type) {
        if (this.interactionSlot == null) {
            return null;
        }
        if (this.interactionSlot.isType(type)) {
            return this.interactionSlot;
        }
        return null;
    }

    private boolean hasItemHandler() {
        return this.itemHandler != null;
    }

    private boolean hasFluidTank() {
        return this.fluidTank != null;
    }

    private boolean hasEnergyTank() {
        return this.energyTank != null;
    }

    private TradeContext(Builder builder) {
        this.isStorageMode = builder.storageMode;
        this.trader = builder.trader;
        this.player = builder.player;
        this.playerReference = builder.playerReference;
        this.bankAccount = builder.bankAccount;
        this.coinSlots = builder.coinSlots;
        this.storedMoney = builder.storedCoins;
        this.moneyListener = builder.moneyListener;
        this.interactionSlot = builder.interactionSlot;
        this.itemHandler = builder.itemHandler;
        this.fluidTank = builder.fluidHandler;
        this.energyTank = builder.energyHandler;
    }

    public boolean hasPaymentMethod() {
        return this.hasPlayer() || this.hasCoinSlots() || this.hasBankAccount() || this.hasStoredMoney();
    }

    public boolean hasFunds(CoinValue price) {
        return this.getAvailableFunds() >= price.getRawValue();
    }

    public long getAvailableFunds() {
        long funds = 0L;
        if (this.hasBankAccount()) {
            funds += this.bankAccount.get().getCoinStorage().getRawValue();
        }
        if (this.hasPlayer()) {
            AtomicLong walletFunds = new AtomicLong(0L);
            WalletCapability.getWalletHandler((Entity)this.player).ifPresent(walletHandler -> {
                ItemStack wallet = walletHandler.getWallet();
                if (WalletItem.isWallet(wallet.m_41720_())) {
                    walletFunds.set(MoneyUtil.getValue(WalletItem.getWalletInventory(wallet)));
                }
            });
            funds += walletFunds.get();
        }
        if (this.hasStoredMoney()) {
            funds += this.storedMoney.getRawValue();
        }
        if (this.hasCoinSlots() && this.hasPlayer()) {
            funds += MoneyUtil.getValue(this.coinSlots);
        }
        return funds;
    }

    public boolean getPayment(CoinValue price) {
        if (this.hasFunds(price)) {
            Object withdrawAmount;
            if (this.moneyListener != null) {
                this.moneyListener.accept(price, false);
            }
            long amountToWithdraw = price.getRawValue();
            if (this.hasCoinSlots() && this.hasPlayer() && (amountToWithdraw = MoneyUtil.takeObjectsOfValue(amountToWithdraw, this.coinSlots, true)) < 0L) {
                List<ItemStack> change = MoneyUtil.getCoinsOfValue(-amountToWithdraw);
                for (ItemStack stack : change) {
                    ItemStack c = InventoryUtil.TryPutItemStack(this.coinSlots, stack);
                    if (c.m_41619_()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)c);
                }
            }
            if (this.hasStoredMoney() && amountToWithdraw > 0L) {
                long removeAmount = Math.min(amountToWithdraw, this.storedMoney.getRawValue());
                amountToWithdraw -= removeAmount;
                this.storedMoney.readFromOldValue(this.storedMoney.getRawValue() - removeAmount);
            }
            if (this.hasBankAccount() && amountToWithdraw > 0L) {
                withdrawAmount = this.bankAccount.get().withdrawCoins(new CoinValue(amountToWithdraw));
                amountToWithdraw -= ((CoinValue)withdrawAmount).getRawValue();
                if (this.hasTrader() && ((CoinValue)withdrawAmount).getRawValue() > 0L) {
                    this.bankAccount.get().LogInteraction(this.getTrader(), (CoinValue)withdrawAmount, false);
                }
            }
            if (this.hasPlayer() && amountToWithdraw > 0L) {
                withdrawAmount = new AtomicLong(amountToWithdraw);
                WalletCapability.getWalletHandler((Entity)this.player).ifPresent(arg_0 -> this.lambda$getPayment$1((AtomicLong)withdrawAmount, arg_0));
                amountToWithdraw = ((AtomicLong)withdrawAmount).get();
            }
            return true;
        }
        return false;
    }

    public boolean givePayment(CoinValue price) {
        if (this.moneyListener != null) {
            this.moneyListener.accept(price, true);
        }
        if (this.hasBankAccount()) {
            this.bankAccount.get().depositCoins(price);
            if (this.hasTrader()) {
                this.bankAccount.get().LogInteraction(this.getTrader(), price, true);
            }
            return true;
        }
        if (this.hasStoredMoney()) {
            this.storedMoney.addValue(price);
            return true;
        }
        if (this.hasPlayer()) {
            List<ItemStack> coins = MoneyUtil.getCoinsOfValue(price);
            AtomicReference<List<ItemStack>> change = new AtomicReference<List<ItemStack>>(coins);
            WalletCapability.getWalletHandler((Entity)this.player).ifPresent(walletHandler -> {
                ItemStack wallet = walletHandler.getWallet();
                if (WalletItem.isWallet(wallet.m_41720_())) {
                    change.set(new ArrayList());
                    for (int i = 0; i < coins.size(); ++i) {
                        ItemStack coin = WalletItem.PickupCoin(wallet, (ItemStack)coins.get(i));
                        if (coin.m_41619_()) continue;
                        ((List)change.get()).add(coin);
                    }
                }
            });
            if (this.hasCoinSlots() && change.get().size() > 0) {
                for (int i = 0; i < change.get().size(); ++i) {
                    ItemStack remainder = InventoryUtil.TryPutItemStack(this.coinSlots, change.get().get(i));
                    if (remainder.m_41619_()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)remainder);
                }
            } else if (change.get().size() > 0) {
                for (int i = 0; i < change.get().size(); ++i) {
                    ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)change.get().get(i));
                }
            }
            return true;
        }
        return false;
    }

    public boolean hasItem(ItemStack item) {
        if (this.hasItemHandler()) {
            return InventoryUtil.CanExtractItem(this.itemHandler, item);
        }
        if (this.hasPlayer()) {
            return InventoryUtil.GetItemCount((Container)this.player.m_150109_(), item) >= item.m_41613_();
        }
        return false;
    }

    public boolean hasItems(ItemStack ... items) {
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean hasTicket(UUID ticketID) {
        block3: {
            block2: {
                if (!this.hasItemHandler()) break block2;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    UUID id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (stack.m_41720_() != ModItems.TICKET || (id = TicketItem.GetTicketID(stack)) == null || !id.equals(ticketID)) continue;
                    ItemStack copyStack = stack.m_41777_();
                    copyStack.m_41764_(1);
                    if (!InventoryUtil.CanExtractItem(this.itemHandler, copyStack)) continue;
                    return true;
                }
                break block3;
            }
            if (!this.hasPlayer()) break block3;
            Inventory inventory = this.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                UUID id;
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41720_() != ModItems.TICKET || (id = TicketItem.GetTicketID(stack)) == null || !id.equals(ticketID)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean collectItem(ItemStack item) {
        if (this.hasItem(item)) {
            if (this.hasItemHandler()) {
                InventoryUtil.RemoveItemCount(this.itemHandler, item);
                return true;
            }
            if (this.hasPlayer()) {
                InventoryUtil.RemoveItemCount((Container)this.player.m_150109_(), item);
                return true;
            }
        }
        return false;
    }

    public boolean collectTicket(UUID ticketID) {
        block2: {
            block3: {
                if (!this.hasTicket(ticketID)) break block2;
                if (!this.hasItemHandler()) break block3;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    UUID id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (stack.m_41720_() != ModItems.TICKET || (id = TicketItem.GetTicketID(stack)) == null || !id.equals(ticketID)) continue;
                    ItemStack extractStack = stack.m_41777_();
                    extractStack.m_41764_(1);
                    if (!InventoryUtil.RemoveItemCount(this.itemHandler, extractStack)) continue;
                    return true;
                }
                break block2;
            }
            if (!this.hasPlayer()) break block2;
            Inventory inventory = this.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                UUID id;
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41720_() != ModItems.TICKET || (id = TicketItem.GetTicketID(stack)) == null || !id.equals(ticketID)) continue;
                inventory.m_7407_(i, 1);
                inventory.m_6596_();
                return true;
            }
        }
        return false;
    }

    public boolean canFitItem(ItemStack item) {
        if (item.m_41619_()) {
            return true;
        }
        if (this.hasItemHandler()) {
            return ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)item, (boolean)true).m_41619_();
        }
        return this.hasPlayer();
    }

    public boolean canFitItems(ItemStack ... items) {
        if (this.hasItemHandler()) {
            IItemHandler original = this.itemHandler;
            IItemHandler copy = null;
            if (original instanceof ICanCopy) {
                copy = (IItemHandler)((ICanCopy)original).copy();
            } else {
                NonNullList inventory = NonNullList.m_122780_((int)original.getSlots(), (Object)ItemStack.f_41583_);
                for (int i = 0; i < original.getSlots(); ++i) {
                    inventory.set(i, (Object)original.getStackInSlot(i));
                }
                copy = new ItemStackHandler(inventory);
            }
            for (ItemStack item : items) {
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)copy, (ItemStack)item, (boolean)false).m_41619_()) continue;
                return false;
            }
            return true;
        }
        return this.hasPlayer();
    }

    public boolean putItem(ItemStack item) {
        if (this.canFitItem(item)) {
            if (this.hasItemHandler()) {
                ItemStack leftovers = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)item, (boolean)false);
                if (leftovers.m_41619_()) {
                    return true;
                }
                ItemStack placedStack = item.m_41777_();
                placedStack.m_41764_(item.m_41613_() - leftovers.m_41613_());
                if (!item.m_41619_()) {
                    this.collectItem(placedStack);
                }
                return false;
            }
            if (this.hasPlayer()) {
                ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)item);
                return true;
            }
        }
        return false;
    }

    public boolean hasFluid(FluidStack fluid) {
        if (this.hasFluidTank()) {
            FluidStack result = this.fluidTank.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
            return !result.isEmpty() && result.getAmount() >= fluid.getAmount();
        }
        if (this.hasInteractionSlot("BUCKET_SLOT")) {
            ItemStack bucketStack = this.getInteractionSlot("BUCKET_SLOT").m_7993_();
            AtomicBoolean hasFluid = new AtomicBoolean(false);
            FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                FluidStack result = fluidHandler.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
                hasFluid.set(!result.isEmpty() && result.getAmount() == fluid.getAmount());
            });
            return hasFluid.get();
        }
        return false;
    }

    public boolean drainFluid(FluidStack fluid) {
        if (this.hasFluid(fluid)) {
            if (this.hasFluidTank()) {
                this.fluidTank.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            if (this.hasInteractionSlot("BUCKET_SLOT")) {
                InteractionSlot slot = this.getInteractionSlot("BUCKET_SLOT");
                ItemStack bucketStack = slot.m_7993_();
                FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                    fluidHandler.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
                    slot.m_5852_(fluidHandler.getContainer());
                });
                return true;
            }
        }
        return false;
    }

    public boolean canFitFluid(FluidStack fluid) {
        if (this.hasFluidTank()) {
            return this.fluidTank.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount();
        }
        if (this.hasInteractionSlot("BUCKET_SLOT")) {
            ItemStack bucketStack = this.getInteractionSlot("BUCKET_SLOT").m_7993_();
            AtomicBoolean fitFluid = new AtomicBoolean(false);
            FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> fitFluid.set(fluidHandler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount()));
            return fitFluid.get();
        }
        return false;
    }

    public boolean fillFluid(FluidStack fluid) {
        if (this.canFitFluid(fluid)) {
            if (this.hasFluidTank()) {
                this.fluidTank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            if (this.hasInteractionSlot("BUCKET_SLOT")) {
                InteractionSlot slot = this.getInteractionSlot("BUCKET_SLOT");
                ItemStack bucketStack = slot.m_7993_();
                FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                    fluidHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                    slot.m_5852_(fluidHandler.getContainer());
                });
            }
        }
        return false;
    }

    public boolean hasEnergy(int amount) {
        if (this.hasEnergyTank()) {
            return this.energyTank.extractEnergy(amount, true) == amount;
        }
        if (this.hasInteractionSlot("ENERGY_SLOT")) {
            ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
            AtomicBoolean hasEnergy = new AtomicBoolean(false);
            batteryStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyHandler -> hasEnergy.set(energyHandler.extractEnergy(amount, true) == amount));
            return hasEnergy.get();
        }
        return false;
    }

    public boolean drainEnergy(int amount) {
        if (this.hasEnergy(amount)) {
            if (this.hasEnergyTank()) {
                this.energyTank.extractEnergy(amount, false);
                return true;
            }
            if (this.hasInteractionSlot("ENERGY_SLOT")) {
                ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
                batteryStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyHandler -> energyHandler.extractEnergy(amount, false));
                return true;
            }
        }
        return false;
    }

    public boolean canFitEnergy(int amount) {
        if (this.hasEnergyTank()) {
            return this.energyTank.receiveEnergy(amount, true) == amount;
        }
        if (this.hasInteractionSlot("ENERGY_SLOT")) {
            ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
            AtomicBoolean fitsEnergy = new AtomicBoolean(false);
            batteryStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyHandler -> fitsEnergy.set(energyHandler.receiveEnergy(amount, true) == amount));
            return fitsEnergy.get();
        }
        return false;
    }

    public boolean fillEnergy(int amount) {
        if (this.canFitEnergy(amount)) {
            if (this.hasEnergyTank()) {
                this.energyTank.receiveEnergy(amount, false);
                return true;
            }
            if (this.hasInteractionSlot("ENERGY_SLOT")) {
                ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
                batteryStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyHandler -> energyHandler.receiveEnergy(amount, false));
                return true;
            }
        }
        return false;
    }

    public static TradeContext createStorageMode(ITrader trader) {
        return new Builder(trader).build();
    }

    public static Builder create(ITrader trader, Player player) {
        return new Builder(trader, player);
    }

    public static Builder create(ITrader trader, PlayerReference player) {
        return new Builder(trader, player);
    }

    private /* synthetic */ void lambda$getPayment$1(AtomicLong withdrawAmount, IWalletHandler walletHandler) {
        ItemStack wallet = walletHandler.getWallet();
        if (WalletItem.isWallet(wallet.m_41720_())) {
            NonNullList<ItemStack> walletInventory = WalletItem.getWalletInventory(wallet);
            long change = MoneyUtil.takeObjectsOfValue(withdrawAmount.get(), walletInventory, true);
            WalletItem.putWalletInventory(wallet, walletInventory);
            if (change < 0L) {
                for (ItemStack stack : MoneyUtil.getCoinsOfValue(-change)) {
                    ItemStack c = WalletItem.PickupCoin(wallet, stack);
                    if (c.m_41619_()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)c);
                }
                change = 0L;
            }
            withdrawAmount.set(change);
        }
    }

    public static class Builder {
        private final boolean storageMode;
        private final ITrader trader;
        private final Player player;
        private final PlayerReference playerReference;
        private BankAccount.AccountReference bankAccount;
        private Container coinSlots;
        private CoinValue storedCoins;
        private BiConsumer<CoinValue, Boolean> moneyListener;
        private InteractionSlot interactionSlot;
        private IItemHandler itemHandler;
        private IFluidHandler fluidHandler;
        private IEnergyStorage energyHandler;

        private Builder(ITrader trader) {
            this.storageMode = true;
            this.trader = trader;
            this.player = null;
            this.playerReference = null;
        }

        private Builder(ITrader trader, Player player) {
            this.trader = trader;
            this.player = player;
            this.playerReference = PlayerReference.of(player);
            this.storageMode = false;
        }

        private Builder(ITrader trader, PlayerReference player) {
            this.trader = trader;
            this.playerReference = player;
            this.player = null;
            this.storageMode = false;
        }

        public Builder withBankAccount(BankAccount.AccountReference bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public Builder withCoinSlots(Container coinSlots) {
            this.coinSlots = coinSlots;
            return this;
        }

        public Builder withStoredCoins(CoinValue storedCoins) {
            this.storedCoins = storedCoins;
            return this;
        }

        public Builder withMoneyListener(BiConsumer<CoinValue, Boolean> moneyListener) {
            this.moneyListener = moneyListener;
            return this;
        }

        public Builder withInteractionSlot(InteractionSlot interactionSlot) {
            this.interactionSlot = interactionSlot;
            return this;
        }

        public Builder withItemHandler(IItemHandler itemHandler) {
            this.itemHandler = itemHandler;
            return this;
        }

        public Builder withFluidHandler(IFluidHandler fluidHandler) {
            this.fluidHandler = fluidHandler;
            return this;
        }

        public Builder withEnergyHandler(IEnergyStorage energyHandler) {
            this.energyHandler = energyHandler;
            return this;
        }

        public TradeContext build() {
            return new TradeContext(this);
        }
    }

    public static enum TradeResult {
        SUCCESS(null),
        FAIL_OUT_OF_STOCK("lightmanscurrency.remotetrade.fail.nostock"),
        FAIL_CANNOT_AFFORD("lightmanscurrency.remotetrade.fail.cantafford"),
        FAIL_NO_OUTPUT_SPACE("lightmanscurrency.remotetrade.fail.nospace.output"),
        FAIL_NO_INPUT_SPACE("lightmanscurrency.remotetrade.fail.nospace.input"),
        FAIL_TRADE_RULE_DENIAL("lightmanscurrency.remotetrade.fail.traderule"),
        FAIL_INVALID_TRADE("lightmanscurrency.remotetrade.fail.invalid"),
        FAIL_NOT_SUPPORTED("lightmanscurrency.remotetrade.fail.notsupported"),
        FAIL_NULL("lightmanscurrency.remotetrade.fail.null");

        public final Component failMessage;

        public boolean hasMessage() {
            return this.failMessage != null;
        }

        private TradeResult(String message) {
            this.failMessage = message == null ? null : new TranslatableComponent(message);
        }
    }
}

