/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.SingleRotatingInstance;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.content.contraptions.fluids.PumpBlock;
import com.simibubi.create.content.contraptions.fluids.PumpTileEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PumpCogInstance
extends SingleRotatingInstance
implements DynamicInstance {
    private final PumpTileEntity blockEntity;
    private final ModelData[] arrows;
    private final Direction direction;

    public PumpCogInstance(MaterialManager modelManager, PumpTileEntity tile) {
        super(modelManager, tile);
        this.blockEntity = (PumpTileEntity)((SingleRotatingInstance)this).blockEntity;
        this.arrows = new ModelData[2];
        this.direction = (Direction)this.blockState.m_61143_((Property)PumpBlock.FACING);
    }

    @Override
    public void init() {
        super.init();
        this.materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllBlockPartials.MECHANICAL_PUMP_ARROW, this.blockState).createInstances((InstanceData[])this.arrows);
    }

    public void beginFrame() {
        float angle = Mth.m_14179_((float)this.blockEntity.arrowDirection.getValue(AnimationTickHolder.getPartialTicks()), (float)0.0f, (float)90.0f) - 90.0f;
        int arrowsLength = this.arrows.length;
        for (int i = 0; i < arrowsLength; ++i) {
            ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.arrows[i].loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotateY((double)(AngleHelper.horizontalAngle(this.direction) + 180.0f))).rotateX((double)(-AngleHelper.verticalAngle(this.direction) - 90.0f))).unCentre()).translate(0.5, 0.875, 0.5).rotateY((double)(90 * i))).rotateZ((double)angle)).translateBack(0.5, 0.875, 0.5);
        }
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, (FlatLit[])this.arrows);
    }

    @Override
    protected Instancer<RotatingData> getModel() {
        BlockState referenceState = this.blockEntity.m_58900_();
        Direction facing = (Direction)referenceState.m_61143_((Property)BlockStateProperties.f_61372_);
        return this.getRotatingMaterial().getModel(AllBlockPartials.MECHANICAL_PUMP_COG, referenceState, facing);
    }

    @Override
    public void remove() {
        super.remove();
        for (ModelData arrow : this.arrows) {
            arrow.delete();
        }
    }
}

