/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.wrench;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.contraptions.wrench.WrenchItemRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class WrenchItem
extends Item {
    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null || !player.m_36326_()) {
            return super.m_6225_(context);
        }
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        Block block = state.m_60734_();
        if (!(block instanceof IWrenchable)) {
            if (this.canWrenchPickup(state)) {
                return this.onItemUseOnOther(context);
            }
            return super.m_6225_(context);
        }
        IWrenchable actor = (IWrenchable)block;
        if (player.m_6144_()) {
            return actor.onSneakWrenched(state, context);
        }
        return actor.onWrenched(state, context);
    }

    private boolean canWrenchPickup(BlockState state) {
        return AllTags.AllBlockTags.WRENCH_PICKUP.matches(state);
    }

    private InteractionResult onItemUseOnOther(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = world.m_8055_(pos);
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && !player.m_7500_()) {
            Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_()).forEach(itemStack -> player.m_150109_().m_150079_(itemStack));
        }
        state.m_60612_((ServerLevel)world, pos, ItemStack.f_41583_);
        world.m_46961_(pos, false);
        AllSoundEvents.WRENCH_REMOVE.playOnServer(world, (Vec3i)pos, 1.0f, Create.RANDOM.nextFloat() * 0.5f + 0.5f);
        return InteractionResult.SUCCESS;
    }

    public static void wrenchInstaKillsMinecarts(AttackEntityEvent event) {
        Entity target = event.getTarget();
        if (!(target instanceof AbstractMinecart)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack heldItem = player.m_21205_();
        if (!AllItems.WRENCH.isIn(heldItem)) {
            return;
        }
        if (player.m_7500_()) {
            return;
        }
        AbstractMinecart minecart = (AbstractMinecart)target;
        minecart.m_6469_(DamageSource.m_19344_((Player)player), 100.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(SimpleCustomRenderer.create(this, new WrenchItemRenderer()));
    }
}

