/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.GlobalRailwayManager;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackGraphRequestPacket;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class TrackGraphRollCallPacket
extends SimplePacketBase {
    int[] ints;

    public TrackGraphRollCallPacket() {
        GlobalRailwayManager manager = Create.RAILWAYS;
        this.ints = new int[manager.trackNetworks.size() * 2];
        int i = 0;
        for (TrackGraph trackGraph : manager.trackNetworks.values()) {
            this.ints[i] = trackGraph.netId;
            this.ints[i + 1] = trackGraph.getChecksum();
            i += 2;
        }
    }

    public TrackGraphRollCallPacket(FriendlyByteBuf buffer) {
        this.ints = new int[buffer.m_130242_()];
        for (int i = 0; i < this.ints.length; ++i) {
            this.ints[i] = buffer.readInt();
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.ints.length);
        for (int i : this.ints) {
            buffer.writeInt(i);
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            GlobalRailwayManager manager = Create.RAILWAYS.sided(null);
            HashSet<UUID> unusedIds = new HashSet<UUID>(manager.trackNetworks.keySet());
            ArrayList<Integer> failedIds = new ArrayList<Integer>();
            HashMap idByNetId = new HashMap();
            manager.trackNetworks.forEach((uuid, g) -> idByNetId.put(g.netId, uuid));
            for (int i = 0; i < this.ints.length; i += 2) {
                UUID uuid2 = (UUID)idByNetId.get(this.ints[i]);
                if (uuid2 == null) {
                    failedIds.add(this.ints[i]);
                    continue;
                }
                unusedIds.remove(uuid2);
                TrackGraph trackGraph = manager.trackNetworks.get(uuid2);
                if (trackGraph.getChecksum() == this.ints[i + 1]) continue;
                Create.LOGGER.warn("Track network: " + uuid2.toString().substring(0, 6) + " failed its checksum; Requesting refresh");
                failedIds.add(this.ints[i]);
            }
            for (Integer failed : failedIds) {
                AllPackets.channel.sendToServer((Object)new TrackGraphRequestPacket(failed));
            }
            for (UUID unused : unusedIds) {
                manager.trackNetworks.remove(unused);
            }
        });
        context.get().setPacketHandled(true);
    }
}

