/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.schedule.destination;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChangeThrottleInstruction
extends ScheduleInstruction {
    public ChangeThrottleInstruction() {
        this.data.m_128405_("Value", 100);
    }

    @Override
    public Pair<ItemStack, Component> getSummary() {
        return Pair.of(this.icon(), this.formatted());
    }

    private TextComponent formatted() {
        return new TextComponent(this.intData("Value") + "%");
    }

    @Override
    public ResourceLocation getId() {
        return Create.asResource("throttle");
    }

    @Override
    public ItemStack getSecondLineIcon() {
        return this.icon();
    }

    @Override
    public boolean supportsConditions() {
        return false;
    }

    @Override
    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translateDirect("schedule." + type + "." + this.getId().m_135815_() + ".summary", this.formatted().m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.GOLD));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addScrollInput(0, 50, (si, l) -> {
            si.withRange(5, 101).withStepFunction(c -> c.shift ? 25 : 5).titled((MutableComponent)Lang.translateDirect("schedule.instruction.throttle_edit_box", new Object[0]));
            l.withSuffix("%");
        }, "Value");
    }

    public float getThrottle() {
        return (float)this.intData("Value") / 100.0f;
    }

    private ItemStack icon() {
        return AllBlocks.CONTROLS.asStack();
    }

    @Override
    public List<Component> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)Lang.translateDirect("schedule.instruction.throttle_edit_box", new Object[0]), (Object)Lang.translateDirect("schedule.instruction.throttle_edit_box_1", new Object[0]).m_130940_(ChatFormatting.GRAY));
    }
}

