/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.events;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.beyond_earth.entities.LanderEntity;
import net.mrscauthd.beyond_earth.events.EntityGravity;
import net.mrscauthd.beyond_earth.events.ItemGravity;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.events.OxygenSystem;
import net.mrscauthd.beyond_earth.events.forge.EntityTickEvent;
import net.mrscauthd.beyond_earth.events.forge.ItemEntityTickEndEvent;
import net.mrscauthd.beyond_earth.events.forge.LivingEntityTickEndEvent;

@Mod.EventBusSubscriber(modid="beyond_earth")
public class Events {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Player player = event.player;
            Level world = player.f_19853_;
            if (player.m_20202_() instanceof LanderEntity) {
                Methods.landerTeleportOrbit(player, world);
            }
            Methods.openPlanetGui(player);
            OxygenSystem.OxygenSystem(player);
            Methods.dropRocket(player);
            if (player instanceof ServerPlayer) {
                Methods.disableFlyAntiCheat((ServerPlayer)player, player.getPersistentData().m_128471_("beyond_earth:planet_selection_gui_open"));
            }
        }
    }

    @SubscribeEvent
    public static void livingEntityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        Methods.entityOxygen(entity, level);
        Methods.venusRain(entity, Methods.venus);
        Methods.planetFire(entity, Methods.venus);
        Methods.planetFire(entity, Methods.mercury);
    }

    @SubscribeEvent
    public static void livingEntityEndTick(LivingEntityTickEndEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        EntityGravity.gravity(entity, level);
    }

    @SubscribeEvent
    public static void itemEntityEndTick(ItemEntityTickEndEvent event) {
        ItemEntity entity = event.getEntityItem();
        Level level = entity.f_19853_;
        ItemGravity.gravity(entity, level);
    }

    @SubscribeEvent
    public static void entityTick(EntityTickEvent event) {
        Entity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (entity.m_20186_() < 1.0 && !(entity.m_20202_() instanceof LanderEntity)) {
            if (entity instanceof LanderEntity && entity.m_20160_()) {
                return;
            }
            Methods.entityFallToPlanet(level, entity);
        }
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Level world = event.world;
            if (Methods.worldsWithoutRain.contains(world.m_46472_())) {
                world.f_46440_ = 0.0f;
                world.f_46438_ = 0.0f;
            } else if (Methods.isWorld(world, Methods.venus)) {
                world.f_46440_ = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public static void livingEntityAttack(LivingAttackEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!event.getSource().m_19384_()) {
            return;
        }
        Player entity = (Player)event.getEntity();
        if (!Methods.netheriteSpaceSuitCheck((LivingEntity)entity)) {
            return;
        }
        entity.m_7311_(0);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void projectileImpact(ProjectileImpactEvent event) {
        if (event.getRayTraceResult().m_6662_() != HitResult.Type.ENTITY) {
            return;
        }
        Entity entity = ((EntityHitResult)event.getRayTraceResult()).m_82443_();
        if (Methods.isVehicle(entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player && event.getEntity().getPersistentData().m_128471_("beyond_earth:planet_selection_gui_open")) {
            Player player = (Player)event.getEntity();
            player.m_6915_();
            Methods.cleanUpPlayerNBT(player);
            player.m_20242_(false);
        }
    }

    @SubscribeEvent
    public static void livingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        if (Methods.isWorld(level, Methods.moon)) {
            event.setDistance(event.getDistance() - 5.5f);
        } else if (Methods.isWorld(level, Methods.mars)) {
            event.setDistance(event.getDistance() - 5.0f);
        } else if (Methods.isWorld(level, Methods.glacio)) {
            event.setDistance(event.getDistance() - 5.0f);
        } else if (Methods.isWorld(level, Methods.mercury)) {
            event.setDistance(event.getDistance() - 5.5f);
        } else if (Methods.isOrbitWorld(level)) {
            event.setDistance(event.getDistance() - 8.5f);
        }
    }
}

