/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.compile;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.backend.gl.shader.GlShader;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class ProgramAssembler {
    public final int program;
    private final ResourceLocation name;
    private final List<GlShader> shaders = new ObjectArrayList();

    public ProgramAssembler(ResourceLocation name) {
        this.name = name;
        this.program = GL20.glCreateProgram();
    }

    public ProgramAssembler link() {
        int result;
        GL20.glLinkProgram((int)this.program);
        String log = GL20.glGetProgramInfoLog((int)this.program);
        if (!log.isEmpty()) {
            Backend.LOGGER.debug("Program link log for " + this.name + ": " + log);
        }
        if ((result = GL20.glGetProgrami((int)this.program, (int)35714)) != 1) {
            throw new RuntimeException("Shader program linking failed, see log for details");
        }
        return this;
    }

    public ProgramAssembler deleteLinkedShaders() {
        this.shaders.forEach(GlObject::delete);
        return this;
    }

    public ProgramAssembler attachShader(GlShader glShader) {
        this.shaders.add(glShader);
        GL20.glAttachShader((int)this.program, (int)glShader.handle());
        return this;
    }

    public <P extends GlProgram> P build(GlProgram.Factory<P> factory) {
        return factory.create(this.name, this.program);
    }
}

