/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.fixed_data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.creative_tabs.CreativeTabFixedData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;

public class CodecUtil {
    public static final Codec<Rarity> RARITY = Codec.either((Codec)Codec.STRING, (Codec)Codec.INT).comapFlatMap(either -> (DataResult)either.map(str -> {
        Rarity rar = Rarity.valueOf((String)str);
        return rar != null ? DataResult.success((Object)rar) : DataResult.error((String)("Unknown rarity value name: " + str));
    }, num -> {
        Rarity[] values = Rarity.values();
        return num >= 0 && num < values.length ? DataResult.success((Object)values[num]) : DataResult.error((String)("Unknown rarity id: " + num));
    }), value -> Either.left((Object)value.name()));
    public static final Codec<FoodProperties> FOOD = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("nutrition").forGetter(obj -> obj.m_38744_()), (App)Codec.FLOAT.fieldOf("saturation").forGetter(obj -> Float.valueOf(obj.m_38745_())), (App)Codec.BOOL.optionalFieldOf("isMeat", (Object)false).forGetter(obj -> obj.m_38746_()), (App)Codec.BOOL.optionalFieldOf("canAlwaysEat", (Object)false).forGetter(obj -> obj.m_38747_()), (App)Codec.BOOL.optionalFieldOf("canEatQuick", (Object)false).forGetter(obj -> obj.m_38748_())).apply((Applicative)instance, (nutrition, saturation, isMeat, canAlwaysEat, canEatQuick) -> {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(nutrition.intValue());
        builder.m_38758_(saturation.floatValue());
        if (isMeat.booleanValue()) {
            builder.m_38757_();
        }
        if (canAlwaysEat.booleanValue()) {
            builder.m_38765_();
        }
        if (canEatQuick.booleanValue()) {
            builder.m_38766_();
        }
        return builder.m_38767_();
    }));
    public static final MapCodec<Item.Properties> ITEM_PROPERTIES = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("maxStackSize", (Object)64).forGetter(o -> 64), (App)Codec.INT.optionalFieldOf("durability", (Object)0).forGetter(o -> 0), (App)Codec.BOOL.optionalFieldOf("fireResistant", (Object)false).forGetter(o -> false), (App)Codec.BOOL.optionalFieldOf("canRepair", (Object)true).forGetter(o -> true), (App)Codec.of((Encoder)Encoder.empty().encoder(), (Decoder)ResourceLocation.f_135803_.map(CreativeTabFixedData::getTab)).optionalFieldOf("creativeTab").forGetter(o -> Optional.empty()), (App)FOOD.optionalFieldOf("food").forGetter(o -> Optional.empty()), (App)RARITY.optionalFieldOf("rarity").forGetter(o -> Optional.empty())).apply((Applicative)instance, (count, durability, fireResistant, canRepair, creativeTab, food, rarity) -> {
        Item.Properties props = new Item.Properties();
        if (count != 64) {
            props.m_41487_(count.intValue());
        }
        if (durability != 0) {
            props.m_41503_(durability.intValue());
        }
        if (fireResistant.booleanValue()) {
            props.m_41486_();
        }
        if (!canRepair.booleanValue()) {
            props.setNoRepair();
        }
        if (food.isPresent()) {
            props.m_41489_((FoodProperties)food.get());
        }
        if (rarity.isPresent()) {
            props.m_41497_((Rarity)rarity.get());
        }
        if (creativeTab.isPresent()) {
            props.m_41491_((CreativeModeTab)creativeTab.get());
        }
        return props;
    }));
}

