/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.fixed_data.creative_tabs;

import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.FixedDataPack;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.creative_tabs.types.BasicTabProvider;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.creative_tabs.types.ICreativeTabProvider;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.util.FixedData;
import net.dark_roleplay.projectbrazier.experimental_features.link.either_codec_registry.CodecDispatchRegistry;
import net.dark_roleplay.projectbrazier.experimental_features.link.either_codec_registry.CodecDispatchType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.Logger;

public class CreativeTabFixedData
extends FixedData {
    private static Map<ResourceLocation, CreativeModeTab> TABS = new HashMap<ResourceLocation, CreativeModeTab>();
    public static final CodecDispatchRegistry<ICreativeTabProvider> CREATIVE_TYPE_PROVIDERS = new CodecDispatchRegistry();

    public static void load(NewRegistryEvent event) {
        TABS.clear();
        FixedDataPack pack = FixedDataPack.getPackForMod("projectbrazier");
        Collection<ResourceLocation> itemLocations = pack.getResources("projectbrazier", "creative_tabs/", Integer.MAX_VALUE, file -> file.endsWith(".json"));
        for (ResourceLocation tabLocation : itemLocations) {
            try {
                String[] splitPath = tabLocation.m_135815_().split("/");
                ResourceLocation registryName = new ResourceLocation("projectbrazier", splitPath[splitPath.length - 1].replace(".json", ""));
                InputStreamReader itemStream = new InputStreamReader(pack.getResource(tabLocation));
                DataResult result = CREATIVE_TYPE_PROVIDERS.getCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)itemStream));
                ICreativeTabProvider provider = (ICreativeTabProvider)result.getOrThrow(false, arg_0 -> ((Logger)LOGGER).warn(arg_0));
                TABS.put(registryName, provider.construct(registryName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static CreativeModeTab getTab(ResourceLocation name) {
        if (!TABS.containsKey(name)) {
            LOGGER.error("Tried to query missing creative Tab {}", (Object)name);
        }
        return TABS.get(name);
    }

    static {
        CREATIVE_TYPE_PROVIDERS.register(new CodecDispatchType<BasicTabProvider>(new ResourceLocation("projectbrazier", "creative_mode_tab"), BasicTabProvider.class, BasicTabProvider.CODEC));
    }
}

