/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.blocks;

import net.dark_roleplay.projectbrazier.feature.blockentities.FlowerContainerBlockEntity;
import net.dark_roleplay.projectbrazier.feature.blocks.templates.DecoBlock;
import net.dark_roleplay.projectbrazier.util.json.VoxelShapeLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FlowerContainerBlock
extends DecoBlock
implements EntityBlock {
    private static TagKey<Item> POT_PLANTS = ItemTags.create((ResourceLocation)new ResourceLocation("projectbrazier", "pot_plant"));
    private VoxelShape allowedPlacementArea;

    public FlowerContainerBlock(BlockBehaviour.Properties properties, String shapeName, String allowedPlacement) {
        super(properties, shapeName);
        this.allowedPlacementArea = VoxelShapeLoader.getVoxelShape(allowedPlacement);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (!(tileEntity instanceof FlowerContainerBlockEntity)) {
            return InteractionResult.FAIL;
        }
        FlowerContainerBlockEntity flowerTileEntity = (FlowerContainerBlockEntity)tileEntity;
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41619_()) {
            ItemStack stack = flowerTileEntity.removeFlower();
            if (!stack.m_41619_()) {
                player.m_36356_(stack);
            }
        } else if (heldItem.m_41720_() instanceof BlockItem && (heldItem.m_204117_(ItemTags.f_13149_) || heldItem.m_204117_(POT_PLANTS))) {
            Vec3 hitPos = hit.m_82450_();
            Vec3i offsetPos = new Vec3i((int)Math.floor((hitPos.m_7096_() - (double)pos.m_123341_()) * 16.0), (int)Math.floor((hitPos.m_7098_() - (double)pos.m_123342_()) * 16.0), (int)Math.floor((hitPos.m_7094_() - (double)pos.m_123343_()) * 16.0));
            boolean isValid = false;
            for (AABB aabb : this.allowedPlacementArea.m_83299_()) {
                isValid |= aabb.m_82393_((double)((float)offsetPos.m_123341_() / 16.0f), (double)((float)offsetPos.m_123342_() / 16.0f), (double)((float)offsetPos.m_123343_() / 16.0f));
            }
            if (isValid) {
                flowerTileEntity.addFlower(heldItem, offsetPos);
            }
        }
        world.m_7260_(pos, state, state, 3);
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state != newState) {
            BlockEntity te = world.m_7702_(pos);
            if (te != null && te instanceof FlowerContainerBlockEntity) {
                FlowerContainerBlockEntity flowerTe = (FlowerContainerBlockEntity)te;
                ItemStack stack = flowerTe.removeFlower();
                while (!stack.m_41619_()) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                    stack = flowerTe.removeFlower();
                }
            }
            world.m_46747_(pos);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FlowerContainerBlockEntity(pos, state);
    }
}

