/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class SittableEntity
extends Entity {
    private BlockState requiredBlock;

    public SittableEntity(EntityType type, Level world) {
        super(type, world);
        this.f_19794_ = true;
        this.requiredBlock = Blocks.f_50016_.m_49966_();
    }

    public SittableEntity(EntityType<SittableEntity> type, Level world, double x, double y, double z, double yOffset, boolean requireBlock) {
        this(type, world);
        this.m_6034_(x, y + yOffset, z);
        if (requireBlock) {
            this.requiredBlock = this.m_20193_().m_8055_(this.m_142538_());
        }
    }

    public void setRotation(Direction facing) {
        this.m_19915_(facing.m_122435_(), 90.0f);
    }

    public void setRequiredBlock(BlockState state) {
        this.requiredBlock = state;
    }

    public double m_6048_() {
        return (double)this.m_6972_((Pose)Pose.STANDING).f_20378_ * 0.0;
    }

    public void m_8119_() {
        if (!(this.m_20193_().f_46443_ || this.m_20160_() && (this.requiredBlock.m_60795_() || this.requiredBlock == this.m_20193_().m_8055_(this.m_142538_())))) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        if (this.m_146909_() < 89.0f || this.m_146909_() > 91.0f) {
            return;
        }
        entityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.f_19859_ += f1 - f;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + f1 - f);
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    protected Vec3 m_20133_(Vec3 pos) {
        Vec3 val = this.m_20133_(pos);
        if (val != Vec3.f_82478_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return val;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7340_(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    protected boolean m_7341_(Entity entityIn) {
        return true;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        NbtUtils.m_129241_((CompoundTag)compound.m_128469_("requiredBlock"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("requiredBlock", (Tag)NbtUtils.m_129202_((BlockState)this.requiredBlock));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
    }

    public Vec3 m_7688_(LivingEntity rider) {
        Level world = this.m_20193_();
        BlockPos pos = this.m_142538_();
        BlockState stateAtPos = world.m_8055_(pos);
        Direction dir = Direction.UP;
        if (stateAtPos.m_61138_((Property)BlockStateProperties.f_61374_)) {
            dir = (Direction)stateAtPos.m_61143_((Property)BlockStateProperties.f_61374_);
        } else if (stateAtPos.m_61138_((Property)BlockStateProperties.f_61372_)) {
            dir = (Direction)stateAtPos.m_61143_((Property)BlockStateProperties.f_61372_);
        } else if (stateAtPos.m_61138_((Property)BlockStateProperties.f_61364_)) {
            Direction.Axis axis = (Direction.Axis)stateAtPos.m_61143_((Property)BlockStateProperties.f_61364_);
            if (axis == Direction.Axis.X) {
                dir = Direction.NORTH;
            } else if (axis == Direction.Axis.Z) {
                dir = Direction.EAST;
            }
        }
        BlockPos.MutableBlockPos testPos = pos.m_122032_();
        if (dir != Direction.UP && (this.isValidDismountPosition(world, (BlockPos)testPos.m_122173_(dir), (Entity)rider) || this.isValidDismountPosition(world, (BlockPos)testPos.m_122159_((Vec3i)pos, dir.m_122427_()), (Entity)rider) || this.isValidDismountPosition(world, (BlockPos)testPos.m_122159_((Vec3i)pos, dir.m_122428_()), (Entity)rider) || this.isValidDismountPosition(world, (BlockPos)testPos.m_122159_((Vec3i)pos, dir.m_122424_()), (Entity)rider))) {
            return new Vec3((double)testPos.m_123341_() + 0.5, (double)testPos.m_123342_() + 0.5, (double)testPos.m_123343_() + 0.5);
        }
        return new Vec3(this.m_20185_(), this.m_142469_().f_82292_ + 1.0, this.m_20189_());
    }

    private boolean isValidDismountPosition(Level world, BlockPos pos, Entity entity) {
        return world.m_8055_(pos).m_60795_() && world.m_8055_(pos.m_7495_()).m_60638_((BlockGetter)world, pos, entity, Direction.UP);
    }
}

