/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.registrars;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.dark_roleplay.marg.common.material.MaterialCondition;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.ItemPropertyLoader;
import net.dark_roleplay.projectbrazier.feature.blocks.templates.MedievalProperties;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierRegistries;
import net.dark_roleplay.projectbrazier.feature.registrars.IFancyNamer;
import net.dark_roleplay.projectbrazier.util.MaterialRegistryObject;
import net.dark_roleplay.projectbrazier.util.marg.EnumMaterialRegistryObject;
import net.dark_roleplay.projectbrazier.util.marg.EnumRegistryObject;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.RegistryObject;

public class Registrar {
    public static final BlockBehaviour.Properties WOOD = BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_();
    public static final BlockBehaviour.Properties WOOD_SOLID = BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_);
    public static BlockBehaviour.Properties METAL = BlockBehaviour.Properties.m_60944_((Material)Material.f_76281_, (MaterialColor)MaterialColor.f_76404_).m_60913_(5.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60955_();
    public static BlockBehaviour.Properties METAL_BRAZIER = BlockBehaviour.Properties.m_60944_((Material)Material.f_76281_, (MaterialColor)MaterialColor.f_76404_).m_60913_(5.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> (Boolean)state.m_61143_((Property)MedievalProperties.BURNING) != false ? 15 : 0).m_60955_();
    public static BlockBehaviour.Properties METAL_SOUL_BRAZIER = BlockBehaviour.Properties.m_60944_((Material)Material.f_76281_, (MaterialColor)MaterialColor.f_76404_).m_60913_(5.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> (Boolean)state.m_61143_((Property)MedievalProperties.BURNING) != false ? 10 : 0).m_60955_();
    public static BlockBehaviour.Properties METAL_GLOW = BlockBehaviour.Properties.m_60944_((Material)Material.f_76281_, (MaterialColor)MaterialColor.f_76404_).m_60913_(5.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> 15).m_60955_();
    public static BlockBehaviour.Properties METAL_SOLID = BlockBehaviour.Properties.m_60944_((Material)Material.f_76281_, (MaterialColor)MaterialColor.f_76404_).m_60913_(5.0f, 1200.0f).m_60918_(SoundType.f_56743_);
    public static BlockBehaviour.Properties STONE = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56742_).m_60955_();
    public static BlockBehaviour.Properties STONE_SOLID = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56742_);
    public static final BlockBehaviour.Properties SNOW_SOLID = BlockBehaviour.Properties.m_60939_((Material)Material.f_76308_).m_60978_(0.3f).m_60918_(SoundType.f_56747_);
    public static BlockBehaviour.Properties PLANT_FUNGI = BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76411_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56740_).m_60955_();
    public static BlockBehaviour.Properties CROP = BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_);
    public static BlockBehaviour.Properties ROPE = BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76406_).m_60978_(0.8f).m_60918_(SoundType.f_56745_);

    public static <T extends Block> RegistryObject<T> registerBlock(String name, Function<BlockBehaviour.Properties, T> factory, BlockBehaviour.Properties props, boolean registerItem) {
        return (registerItem ? BrazierRegistries.BLOCKS : BrazierRegistries.BLOCKS_NO_ITEMS).register(name, () -> (Block)factory.apply(props));
    }

    public static <T extends Enum<T>, B extends Block> EnumMaterialRegistryObject<T, B> registerBlock(String name, Class<T> clazz, MaterialCondition condition, Function<BlockBehaviour.Properties, B> supplier, Function<MargMaterial, BlockBehaviour.Properties> propertyFactory, boolean registerItem) {
        EnumMaterialRegistryObject<B, B> regObj = new EnumMaterialRegistryObject<B, B>(clazz);
        for (Enum type : (Enum[])clazz.getEnumConstants()) {
            String enumizedName = "";
            enumizedName = type instanceof IFancyNamer ? ((IFancyNamer)((Object)type)).processFancyName(name) : String.format(name, type.name().toLowerCase(Locale.ROOT));
            for (MargMaterial material : condition) {
                regObj.register(type, material, Registrar.registerBlock(material.getTextProvider().apply(enumizedName), supplier, propertyFactory.apply(material), registerItem));
            }
        }
        return regObj;
    }

    public static <T extends Enum<T>, B extends Block> EnumRegistryObject<T, B> registerBlock(String name, Class<T> clazz, Function<BlockBehaviour.Properties, B> supplier, BlockBehaviour.Properties props, boolean registerItem) {
        return Registrar.registerBlock(name, clazz, (T type) -> true, supplier, props, registerItem);
    }

    public static <T extends Enum<T>, B extends Block> EnumRegistryObject<T, B> registerBlock(String name, Class<T> clazz, Predicate<T> filter, Function<BlockBehaviour.Properties, B> supplier, BlockBehaviour.Properties props, boolean registerItem) {
        EnumRegistryObject<B, B> regObj = new EnumRegistryObject<B, B>(clazz);
        for (Enum type : (Enum[])clazz.getEnumConstants()) {
            if (!filter.test(type)) continue;
            if (type instanceof IFancyNamer) {
                regObj.register(type, Registrar.registerBlock(((IFancyNamer)((Object)type)).processFancyName(name), supplier, props, registerItem));
                continue;
            }
            regObj.register(type, Registrar.registerBlock(String.format(name, type.name().toLowerCase(Locale.ROOT)), supplier, props, registerItem));
        }
        return regObj;
    }

    public static <T extends Block> MaterialRegistryObject<T> registerBlock(String name, MaterialCondition condition, Function<BlockBehaviour.Properties, T> factory, Function<MargMaterial, BlockBehaviour.Properties> propertyFactory, boolean createItem) {
        return Registrar.registerBlock(name, condition, (MargMaterial material, BlockBehaviour.Properties props) -> (Block)factory.apply((BlockBehaviour.Properties)props), propertyFactory, createItem);
    }

    public static <T extends Block> MaterialRegistryObject<T> registerBlock(String name, MaterialCondition condition, BiFunction<MargMaterial, BlockBehaviour.Properties, T> factory, Function<MargMaterial, BlockBehaviour.Properties> propertyFactory, boolean createItem) {
        MaterialRegistryObject blocks = new MaterialRegistryObject();
        for (MargMaterial material : condition) {
            String materializedName = material.getTextProvider().apply(name);
            blocks.register(material, (createItem ? BrazierRegistries.BLOCKS : BrazierRegistries.BLOCKS_NO_ITEMS).register(materializedName, () -> (Block)factory.apply(material, (BlockBehaviour.Properties)propertyFactory.apply(material))));
        }
        return blocks;
    }

    public static RegistryObject<Item> registerItem(String name) {
        return Registrar.registerItem(name, Item::new);
    }

    public static <T extends Item> RegistryObject<T> registerItem(String name, Function<Item.Properties, T> supplier) {
        return BrazierRegistries.ITEMS.register(name, () -> (Item)supplier.apply(ItemPropertyLoader.getProp(name)));
    }

    public static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> registerContainer(String name, IContainerFactory<T> factory) {
        return BrazierRegistries.CONTAINERS.register(name, () -> new MenuType((MenuType.MenuSupplier)factory));
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerBlockEntity(String name, BlockEntityType.BlockEntitySupplier<T> supplier, RegistryObject<Block> ... blocks) {
        return BrazierRegistries.BLOCK_ENTITIES.register(name, () -> Registrar.createType(supplier, blocks));
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerBlockEntity(String name, BlockEntityType.BlockEntitySupplier<T> supplier, Collection<RegistryObject<Block>> ... blocks) {
        return BrazierRegistries.BLOCK_ENTITIES.register(name, () -> Registrar.createType(supplier, blocks));
    }

    private static <T extends BlockEntity> BlockEntityType<T> createType(BlockEntityType.BlockEntitySupplier<T> supplier, RegistryObject<Block> ... blocks) {
        return BlockEntityType.Builder.m_155273_(supplier, (Block[])Arrays.stream(blocks).map(ro -> (Block)ro.get()).collect(Collectors.toList()).toArray(new Block[blocks.length])).m_58966_(null);
    }

    private static <T extends BlockEntity> BlockEntityType<T> createType(BlockEntityType.BlockEntitySupplier<T> supplier, Collection<RegistryObject<Block>> ... blocks) {
        return BlockEntityType.Builder.m_155273_(supplier, (Block[])((Block[])Arrays.stream(blocks).flatMap(col -> col.stream()).map(RegistryObject::get).toArray(Block[]::new))).m_58966_(null);
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> registerEntity(String name, Supplier<EntityType<T>> supplier) {
        return BrazierRegistries.ENTITIES.register(name, supplier);
    }

    public static BlockBehaviour.Properties MARG_WOOD(MargMaterial material) {
        return BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)material.getProperties().getMapColor()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_();
    }

    public static <R extends FeatureConfiguration, T extends Feature<R>> RegistryObject<Feature<R>> registerFeature(String name, Supplier<Feature<R>> supplier) {
        return BrazierRegistries.FEATURES.register(name, supplier);
    }

    private static <P extends PlacementModifier> PlacementModifierType<P> register(ResourceLocation resourceLocation, Codec<P> codec) {
        return (PlacementModifierType)Registry.m_122965_((Registry)Registry.f_194570_, (ResourceLocation)resourceLocation, () -> codec);
    }
}

