/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.proxy;

import io.github.kosmx.emotes.api.proxy.EmotesProxyManager;
import io.github.kosmx.emotes.common.network.EmotePacket;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;

public interface INetworkInstance {
    @Deprecated
    default public HashMap<Byte, Byte> getVersions() {
        return null;
    }

    default public HashMap<Byte, Byte> getRemoteVersions() {
        return this.getVersions();
    }

    public void setVersions(HashMap<Byte, Byte> var1);

    default public void presenceResponse() {
    }

    default public boolean sendPlayerID() {
        return false;
    }

    public void sendMessage(EmotePacket.Builder var1, @Nullable UUID var2) throws IOException;

    default public void receiveMessage(ByteBuffer byteBuffer, UUID player) {
        EmotesProxyManager.receiveMessage(byteBuffer, player, this);
    }

    public void sendConfigCallback();

    default public boolean trustReceivedPlayer() {
        return true;
    }

    default public boolean safeProxy() {
        return true;
    }

    public boolean isActive();

    public int getRemoteVersion();

    public boolean isServerTrackingPlayState();

    public int maxDataSize();

    public static byte[] safeGetBytesFromBuffer(ByteBuffer byteBuffer) {
        try {
            if (byteBuffer.isDirect() || byteBuffer.isReadOnly()) {
                byte[] bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
                return bytes;
            }
            return byteBuffer.array();
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            e.printStackTrace();
            return null;
        }
    }
}

