/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.network;

import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayerEntity;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.network.ClientPacketManager;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class ClientEmotePlay {
    private static final HashMap<UUID, QueueEntry> queue = new HashMap();

    public static void clientStartLocalEmote(EmoteHolder emoteHolder) {
        ClientEmotePlay.clientStartLocalEmote(emoteHolder.getEmote());
    }

    public static boolean clientStartLocalEmote(EmoteData emote) {
        IEmotePlayerEntity player = EmoteInstance.instance.getClientMethods().getMainPlayer();
        if (player.isForcedEmote()) {
            return false;
        }
        EmotePacket.Builder packetBuilder = new EmotePacket.Builder();
        packetBuilder.configureToStreamEmote(emote, player.emotes_getUUID());
        ClientPacketManager.send(packetBuilder, null);
        EmoteInstance.instance.getClientMethods().getMainPlayer().playEmote(emote, 0, false);
        return true;
    }

    public static void clientRepeatLocalEmote(EmoteData emote, int tick, UUID target) {
        EmotePacket.Builder packetBuilder = new EmotePacket.Builder();
        packetBuilder.configureToStreamEmote(emote, EmoteInstance.instance.getClientMethods().getMainPlayer().emotes_getUUID()).configureEmoteTick(tick);
        ClientPacketManager.send(packetBuilder, target);
    }

    public static void clientStopLocalEmote() {
        if (EmoteInstance.instance.getClientMethods().getMainPlayer().isPlayingEmote()) {
            ClientEmotePlay.clientStopLocalEmote(EmoteInstance.instance.getClientMethods().getMainPlayer().getEmote().getData());
        }
    }

    public static void clientStopLocalEmote(EmoteData emoteData) {
        EmotePacket.Builder packetBuilder = new EmotePacket.Builder();
        packetBuilder.configureToSendStop(emoteData.getUuid(), EmoteInstance.instance.getClientMethods().getMainPlayer().emotes_getUUID());
        ClientPacketManager.send(packetBuilder, null);
        EmoteInstance.instance.getClientMethods().getMainPlayer().stopEmote();
    }

    static void executeMessage(NetData data, INetworkInstance networkInstance) throws NullPointerException {
        EmoteInstance.instance.getLogger().log(Level.FINEST, "[emotes client] Received message: " + data);
        if (data.purpose == null && ((Boolean)EmoteInstance.config.showDebug.get()).booleanValue()) {
            EmoteInstance.instance.getLogger().log(Level.INFO, "Packet execution is not possible without a purpose");
        }
        switch (Objects.requireNonNull(data.purpose)) {
            case STREAM: {
                assert (data.emoteData != null);
                if (!data.valid && (((ClientConfig)EmoteInstance.config).alwaysValidate.get().booleanValue() || !networkInstance.safeProxy())) break;
                ClientEmotePlay.receivePlayPacket(data.emoteData, data.player, data.tick, data.isForced);
                break;
            }
            case STOP: {
                IEmotePlayerEntity player = EmoteInstance.instance.getGetters().getPlayerFromUUID(data.player);
                assert (data.stopEmoteID != null);
                if (player != null) {
                    player.stopEmote(data.stopEmoteID);
                    if (!player.isMainPlayer() || data.isForced) break;
                    EmoteInstance.instance.getClientMethods().sendChatMessage(EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.blockedEmote"));
                    break;
                }
                queue.remove(data.player);
                break;
            }
            case CONFIG: {
                networkInstance.setVersions(Objects.requireNonNull(data.versions));
                break;
            }
            case FILE: {
                EmoteHolder.addEmoteToList((EmoteData)data.emoteData).fromInstance = networkInstance;
            }
            case UNKNOWN: {
                if (!((Boolean)EmoteInstance.config.showDebug.get()).booleanValue()) break;
                EmoteInstance.instance.getLogger().log(Level.INFO, "Packet execution is not possible unknown purpose");
            }
        }
    }

    static void receivePlayPacket(EmoteData emoteData, UUID player, int tick, boolean isForced) {
        IEmotePlayerEntity playerEntity = EmoteInstance.instance.getGetters().getPlayerFromUUID(player);
        if (ClientEmotePlay.isEmoteAllowed(emoteData, player)) {
            if (playerEntity != null) {
                playerEntity.playEmote(emoteData, tick, isForced);
            } else {
                ClientEmotePlay.addToQueue(new QueueEntry(emoteData, tick, EmoteInstance.instance.getClientMethods().getCurrentTick()), player);
            }
        }
    }

    public static boolean isEmoteAllowed(EmoteData emoteData, UUID player) {
        return !(((ClientConfig)EmoteInstance.config).enablePlayerSafety.get() == false && EmoteInstance.instance.getClientMethods().isPlayerBlocked(player) || emoteData.nsfw && ((ClientConfig)EmoteInstance.config).enableNSFW.get() == false);
    }

    static void addToQueue(QueueEntry entry, UUID player) {
        queue.put(player, entry);
    }

    @Nullable
    public static Pair<EmoteData, Integer> getEmoteForUUID(UUID uuid) {
        if (queue.containsKey(uuid)) {
            QueueEntry entry = queue.get(uuid);
            EmoteData emoteData = entry.emoteData;
            int tick = entry.beginTick - entry.receivedTick + EmoteInstance.instance.getClientMethods().getCurrentTick();
            queue.remove(uuid);
            if (!emoteData.isPlayingAt(tick)) {
                return null;
            }
            return new Pair<EmoteData, Integer>(emoteData, tick);
        }
        return null;
    }

    public static void checkQueue() {
        int currentTick = EmoteInstance.instance.getClientMethods().getCurrentTick();
        queue.forEach((uuid, entry) -> {
            if (!entry.emoteData.isPlayingAt(entry.beginTick + currentTick) && entry.beginTick + currentTick > 0 || EmoteInstance.instance.getClientMethods().getCurrentTick() - entry.receivedTick > 24000) {
                queue.remove(uuid);
            }
        });
    }

    static class QueueEntry {
        final EmoteData emoteData;
        final int beginTick;
        final int receivedTick;

        QueueEntry(EmoteData emoteData, int begin, int received) {
            this.emoteData = emoteData;
            this.beginTick = begin;
            this.receivedTick = received;
        }
    }
}

