/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.playerAnim.layered;

import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.common.tools.Easing;
import io.github.kosmx.emotes.common.tools.MathHelper;
import io.github.kosmx.emotes.common.tools.Vec3f;
import io.github.kosmx.playerAnim.TransformType;
import io.github.kosmx.playerAnim.layered.IAnimation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class EmoteDataPlayer
implements IAnimation {
    private final EmoteData data;
    private boolean isRunning = true;
    private int currentTick = 0;
    private boolean isLoopStarted = false;
    protected float tickDelta;
    public final HashMap<String, BodyPart> bodyParts;
    public int perspective = 0;

    public EmoteDataPlayer(EmoteData emote, int t) {
        this.data = emote;
        this.bodyParts = new HashMap(emote.bodyParts.size());
        for (Map.Entry<String, EmoteData.StateCollection> part : emote.bodyParts.entrySet()) {
            this.bodyParts.put(part.getKey(), new BodyPart(part.getValue()));
        }
        this.currentTick = t;
        if (this.isInfinite() && t > this.data.returnToTick) {
            this.currentTick = (t - this.data.returnToTick) % (this.data.endTick - this.data.returnToTick) + this.data.returnToTick;
        }
    }

    @Override
    public void tick() {
        if (this.isRunning) {
            ++this.currentTick;
            if (this.data.isInfinite && this.currentTick >= this.data.endTick) {
                this.currentTick = this.data.returnToTick;
                this.isLoopStarted = true;
            }
            if (this.currentTick >= this.data.stopTick) {
                this.stop();
            }
        }
    }

    public int getTick() {
        return this.currentTick;
    }

    public void stop() {
        this.isRunning = false;
    }

    @Override
    public boolean isActive() {
        return this.isRunning;
    }

    @Override
    public Vec3f get3DTransform(String modelName, TransformType type, float tickDelta, Vec3f value0) {
        BodyPart part = this.bodyParts.get(modelName);
        if (part == null) {
            return value0;
        }
        switch (type) {
            case POSITION: {
                return part.getBodyOffset(value0);
            }
            case ROTATION: {
                Vec3f rot = part.getBodyRotation(value0);
                return new Vec3f(((Float)rot.getX()).floatValue(), ((Float)rot.getY()).floatValue(), ((Float)rot.getZ()).floatValue());
            }
            case BEND: {
                Pair<Float, Float> bend = part.getBend(new Pair<Float, Float>((Float)value0.getX(), (Float)value0.getY()));
                return new Vec3f(bend.getLeft().floatValue(), bend.getRight().floatValue(), 0.0f);
            }
        }
        return value0;
    }

    @Override
    public void setupAnim(float tickDelta) {
        this.tickDelta = tickDelta;
    }

    public boolean isLoopStarted() {
        return this.isLoopStarted;
    }

    public EmoteData getData() {
        return this.data;
    }

    public BodyPart getPart(String string) {
        BodyPart part = this.bodyParts.get(string);
        return part == null ? new BodyPart(null) : part;
    }

    public int getStopTick() {
        return this.data.stopTick;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public boolean isInfinite() {
        return this.data.isInfinite;
    }

    public class BodyPart {
        @Nullable
        public final EmoteData.StateCollection part;
        public final Axis x;
        public final Axis y;
        public final Axis z;
        public final RotationAxis pitch;
        public final RotationAxis yaw;
        public final RotationAxis roll;
        public final RotationAxis bendAxis;
        public final RotationAxis bend;

        public BodyPart(EmoteData.StateCollection part) {
            this.part = part;
            if (part != null) {
                this.x = new Axis(part.x);
                this.y = new Axis(part.y);
                this.z = new Axis(part.z);
                this.pitch = new RotationAxis(part.pitch);
                this.yaw = new RotationAxis(part.yaw);
                this.roll = new RotationAxis(part.roll);
                this.bendAxis = new RotationAxis(part.bendDirection);
                this.bend = new RotationAxis(part.bend);
            } else {
                this.x = null;
                this.y = null;
                this.z = null;
                this.pitch = null;
                this.yaw = null;
                this.roll = null;
                this.bendAxis = null;
                this.bend = null;
            }
        }

        public Pair<Float, Float> getBend(Pair<Float, Float> value0) {
            if (this.bend == null) {
                return value0;
            }
            return new Pair<Float, Float>(Float.valueOf(this.bendAxis.getValueAtCurrentTick(value0.getLeft().floatValue())), Float.valueOf(this.bend.getValueAtCurrentTick(value0.getRight().floatValue())));
        }

        public Vec3f getBodyOffset(Vec3f value0) {
            if (this.part == null) {
                return value0;
            }
            float x = this.x.getValueAtCurrentTick(((Float)value0.getX()).floatValue());
            float y = this.y.getValueAtCurrentTick(((Float)value0.getY()).floatValue());
            float z = this.z.getValueAtCurrentTick(((Float)value0.getZ()).floatValue());
            return new Vec3f(x, y, z);
        }

        public Vec3f getBodyRotation(Vec3f value0) {
            if (this.part == null) {
                return value0;
            }
            return new Vec3f(this.pitch.getValueAtCurrentTick(((Float)value0.getX()).floatValue()), this.yaw.getValueAtCurrentTick(((Float)value0.getY()).floatValue()), this.roll.getValueAtCurrentTick(((Float)value0.getZ()).floatValue()));
        }
    }

    public class RotationAxis
    extends Axis {
        public RotationAxis(EmoteData.StateCollection.State keyframes) {
            super(keyframes);
        }

        @Override
        public float getValueAtCurrentTick(float currentValue) {
            return MathHelper.clampToRadian(super.getValueAtCurrentTick(MathHelper.clampToRadian(currentValue)));
        }
    }

    public class Axis {
        protected final EmoteData.StateCollection.State keyframes;

        public Axis(EmoteData.StateCollection.State keyframes) {
            this.keyframes = keyframes;
        }

        private EmoteData.KeyFrame findBefore(int pos, float currentState) {
            if (pos == -1) {
                return EmoteDataPlayer.this.currentTick < ((EmoteDataPlayer)EmoteDataPlayer.this).data.beginTick ? new EmoteData.KeyFrame(0, currentState) : (EmoteDataPlayer.this.currentTick < ((EmoteDataPlayer)EmoteDataPlayer.this).data.endTick ? new EmoteData.KeyFrame(((EmoteDataPlayer)EmoteDataPlayer.this).data.beginTick, this.keyframes.defaultValue) : new EmoteData.KeyFrame(((EmoteDataPlayer)EmoteDataPlayer.this).data.endTick, this.keyframes.defaultValue));
            }
            return this.keyframes.keyFrames.get(pos);
        }

        private EmoteData.KeyFrame findAfter(int pos, float currentState) {
            if (this.keyframes.length() > pos + 1) {
                return this.keyframes.keyFrames.get(pos + 1);
            }
            return EmoteDataPlayer.this.currentTick >= ((EmoteDataPlayer)EmoteDataPlayer.this).data.endTick ? new EmoteData.KeyFrame(((EmoteDataPlayer)EmoteDataPlayer.this).data.stopTick, currentState) : (EmoteDataPlayer.this.currentTick >= EmoteDataPlayer.this.getData().beginTick ? new EmoteData.KeyFrame(EmoteDataPlayer.this.getData().endTick, this.keyframes.defaultValue) : new EmoteData.KeyFrame(EmoteDataPlayer.this.getData().beginTick, this.keyframes.defaultValue));
        }

        public float getValueAtCurrentTick(float currentValue) {
            if (this.keyframes.isEnabled) {
                int pos = this.keyframes.findAtTick(EmoteDataPlayer.this.currentTick);
                EmoteData.KeyFrame keyBefore = this.findBefore(pos, currentValue);
                if (EmoteDataPlayer.this.isLoopStarted && keyBefore.tick < ((EmoteDataPlayer)EmoteDataPlayer.this).data.returnToTick) {
                    keyBefore = this.findBefore(this.keyframes.findAtTick(((EmoteDataPlayer)EmoteDataPlayer.this).data.endTick), currentValue);
                }
                EmoteData.KeyFrame keyAfter = this.findAfter(pos, currentValue);
                if (((EmoteDataPlayer)EmoteDataPlayer.this).data.isInfinite && keyAfter.tick >= ((EmoteDataPlayer)EmoteDataPlayer.this).data.endTick) {
                    keyAfter = this.findAfter(this.keyframes.findAtTick(((EmoteDataPlayer)EmoteDataPlayer.this).data.returnToTick - 1), currentValue);
                }
                return this.getValueFromKeyframes(keyBefore, keyAfter);
            }
            return currentValue;
        }

        protected final float getValueFromKeyframes(EmoteData.KeyFrame before, EmoteData.KeyFrame after) {
            int tickBefore = before.tick;
            int tickAfter = after.tick;
            if (tickBefore >= tickAfter) {
                if (EmoteDataPlayer.this.currentTick < tickBefore) {
                    tickBefore -= ((EmoteDataPlayer)EmoteDataPlayer.this).data.endTick - ((EmoteDataPlayer)EmoteDataPlayer.this).data.returnToTick;
                } else {
                    tickAfter += ((EmoteDataPlayer)EmoteDataPlayer.this).data.endTick - ((EmoteDataPlayer)EmoteDataPlayer.this).data.returnToTick;
                }
            }
            if (tickBefore == tickAfter) {
                return before.value;
            }
            float f = ((float)EmoteDataPlayer.this.currentTick + EmoteDataPlayer.this.tickDelta - (float)tickBefore) / (float)(tickAfter - tickBefore);
            return MathHelper.lerp(Easing.easingFromEnum(((EmoteDataPlayer)EmoteDataPlayer.this).data.isEasingBefore ? after.ease : before.ease, f), before.value, after.value);
        }
    }
}

