/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.belt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gigaherz.toolbelt.ToolBelt;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class BeltIngredient
extends Ingredient {
    public static final ResourceLocation NAME = ToolBelt.location("belt_upgrade_level");
    private final int level;

    public static BeltIngredient withLevel(int level) {
        return new BeltIngredient(level);
    }

    protected BeltIngredient(int level) {
        super(Stream.of(new Ingredient.ItemValue(ToolBelt.BELT.of(level))));
        this.level = level;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.m_41720_() == ToolBelt.BELT && ToolBelt.BELT.getLevel(stack) == this.level;
    }

    public JsonElement m_43942_() {
        JsonObject object = new JsonObject();
        object.addProperty("type", NAME.toString());
        object.addProperty("upgrade_level", (Number)this.level);
        return object;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<BeltIngredient> {
        public static final IIngredientSerializer<? extends Ingredient> INSTANCE = new Serializer();

        public BeltIngredient parse(FriendlyByteBuf buffer) {
            return new BeltIngredient(buffer.m_130242_());
        }

        public void write(FriendlyByteBuf buffer, BeltIngredient ingredient) {
            buffer.m_130130_(ingredient.level);
        }

        public BeltIngredient parse(JsonObject json) {
            return new BeltIngredient(GsonHelper.m_13927_((JsonObject)json, (String)"upgrade_level"));
        }
    }
}

