/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.network.message;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.mindoth.skillcloaks.client.InventoryCraftingMenu;
import net.mindoth.skillcloaks.registries.SkillCloaksItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class CloakAbilityPacket {
    public static final UUID UNION_UUID = UUID.fromString("e8ef4b7d-f91a-4a40-b020-c44386355641");
    public static final UUID JAPE_UUID = UUID.fromString("fbf6c2ec-9236-47c5-92c8-f5f5d2856014");
    private static final String TAG_MAX_MODE = "skillcloak.mode";
    public int key;
    private static final Component CONTAINER_TITLE = new TranslatableComponent("container.crafting");

    public CloakAbilityPacket() {
    }

    public CloakAbilityPacket(int key) {
        this.key = key;
    }

    public static void encode(CloakAbilityPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.key);
    }

    public static CloakAbilityPacket decode(FriendlyByteBuf buffer) {
        return new CloakAbilityPacket(buffer.readInt());
    }

    private static SmokingRecipe getSmokingRecipe(Player player, Container inv) {
        return player.f_19853_.m_7465_().m_44015_(RecipeType.f_44110_, inv, player.f_19853_).orElse(null);
    }

    private static BlastingRecipe getBlastingRecipe(Player player, Container inv) {
        return player.f_19853_.m_7465_().m_44015_(RecipeType.f_44109_, inv, player.f_19853_).orElse(null);
    }

    public static MenuProvider getMenuProvider(Level pLevel, BlockPos pPos) {
        return new SimpleMenuProvider((p_52229_, p_52230_, p_52231_) -> new InventoryCraftingMenu(p_52229_, p_52230_, ContainerLevelAccess.m_39289_((Level)pLevel, (BlockPos)pPos)), CONTAINER_TITLE);
    }

    public static void handle(CloakAbilityPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ItemStack result;
            ItemEntity drop;
            BlastingRecipe recipeOff0;
            BlastingRecipe recipe0;
            SmokingRecipe recipeOff;
            SmokingRecipe recipe;
            SimpleContainer slotInvOff;
            SimpleContainer slotInv;
            ItemStack offHandItemStack;
            ItemStack mainHandItemStack;
            ServerPlayer player = context.getSender();
            ServerLevel world = player.m_183503_();
            CompoundTag playerMaxData = player.getPersistentData();
            CompoundTag maxData = playerMaxData.m_128469_("PlayerPersisted");
            if (player.m_6844_(EquipmentSlot.MAINHAND).m_41720_().equals(SkillCloaksItems.MAX_CLOAK.get()) && !player.m_36335_().m_41519_((Item)SkillCloaksItems.MAX_CLOAK.get())) {
                switch (maxData.m_128451_(TAG_MAX_MODE)) {
                    case 1: {
                        maxData.m_128405_(TAG_MAX_MODE, 2);
                        playerMaxData.m_128365_("PlayerPersisted", (Tag)maxData);
                        player.m_5661_((Component)new TextComponent("Construction Mode"), true);
                        player.m_36335_().m_41524_((Item)SkillCloaksItems.MAX_CLOAK.get(), 20);
                        break;
                    }
                    case 2: {
                        if (ModList.get().isLoaded("lucent")) {
                            maxData.m_128405_(TAG_MAX_MODE, 1);
                        } else {
                            maxData.m_128405_(TAG_MAX_MODE, 3);
                        }
                        playerMaxData.m_128365_("PlayerPersisted", (Tag)maxData);
                        player.m_5661_((Component)new TextComponent("Crafting Mode"), true);
                        player.m_36335_().m_41524_((Item)SkillCloaksItems.MAX_CLOAK.get(), 20);
                        break;
                    }
                    case 3: {
                        maxData.m_128405_(TAG_MAX_MODE, 1);
                        playerMaxData.m_128365_("PlayerPersisted", (Tag)maxData);
                        player.m_5661_((Component)new TextComponent("Firemaking Mode"), true);
                        player.m_36335_().m_41524_((Item)SkillCloaksItems.MAX_CLOAK.get(), 20);
                        break;
                    }
                    default: {
                        maxData.m_128405_(TAG_MAX_MODE, 2);
                        playerMaxData.m_128365_("PlayerPersisted", (Tag)maxData);
                        player.m_5661_((Component)new TextComponent("Construction Mode"), true);
                        player.m_36335_().m_41524_((Item)SkillCloaksItems.MAX_CLOAK.get(), 20);
                    }
                }
            }
            if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.CRAFTING_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.MAX_CLOAK.get()).isPresent()) {
                mainHandItemStack = player.m_21205_();
                offHandItemStack = player.m_21206_();
                slotInv = new SimpleContainer(new ItemStack[]{mainHandItemStack});
                slotInvOff = new SimpleContainer(new ItemStack[]{offHandItemStack});
                recipe = CloakAbilityPacket.getSmokingRecipe((Player)player, (Container)slotInv);
                recipeOff = CloakAbilityPacket.getSmokingRecipe((Player)player, (Container)slotInvOff);
                recipe0 = CloakAbilityPacket.getBlastingRecipe((Player)player, (Container)slotInv);
                recipeOff0 = CloakAbilityPacket.getBlastingRecipe((Player)player, (Container)slotInvOff);
                if (!(recipe != null && offHandItemStack.m_41720_().equals(Items.f_42409_) || recipeOff != null && mainHandItemStack.m_41720_().equals(Items.f_42409_) || recipe0 != null && offHandItemStack.m_41720_().equals(Items.f_42409_) || recipeOff0 != null && mainHandItemStack.m_41720_().equals(Items.f_42409_))) {
                    if (ModList.get().isLoaded("lucent")) {
                        if (maxData.m_128451_(TAG_MAX_MODE) == 1) {
                            player.m_5893_(CloakAbilityPacket.getMenuProvider(player.f_19853_, player.m_142538_()));
                        }
                    } else if (maxData.m_128451_(TAG_MAX_MODE) == 3) {
                        player.m_5893_(CloakAbilityPacket.getMenuProvider(player.f_19853_, player.m_142538_()));
                    }
                }
            }
            if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.CONSTRUCTION_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.MAX_CLOAK.get()).isPresent() && maxData.m_128451_(TAG_MAX_MODE) == 2) {
                mainHandItemStack = player.m_21205_();
                offHandItemStack = player.m_21206_();
                slotInv = new SimpleContainer(new ItemStack[]{mainHandItemStack});
                slotInvOff = new SimpleContainer(new ItemStack[]{offHandItemStack});
                recipe = CloakAbilityPacket.getSmokingRecipe((Player)player, (Container)slotInv);
                recipeOff = CloakAbilityPacket.getSmokingRecipe((Player)player, (Container)slotInvOff);
                recipe0 = CloakAbilityPacket.getBlastingRecipe((Player)player, (Container)slotInv);
                recipeOff0 = CloakAbilityPacket.getBlastingRecipe((Player)player, (Container)slotInvOff);
                if (!(recipe != null && offHandItemStack.m_41720_().equals(Items.f_42409_) || recipeOff != null && mainHandItemStack.m_41720_().equals(Items.f_42409_) || recipe0 != null && offHandItemStack.m_41720_().equals(Items.f_42409_) || recipeOff0 != null && mainHandItemStack.m_41720_().equals(Items.f_42409_) || player.m_36335_().m_41519_((Item)SkillCloaksItems.CONSTRUCTION_CLOAK.get()) || player.m_36335_().m_41519_((Item)SkillCloaksItems.MAX_CLOAK.get()))) {
                    ServerLevel respawnWorld = player.f_8924_.m_129880_(player.m_8963_());
                    BlockPos spawn = player.m_8961_();
                    if (spawn != null && respawnWorld != null) {
                        BlockState blockstate = respawnWorld.m_8055_(spawn);
                        if (respawnWorld == world) {
                            if (blockstate.m_60713_(Blocks.f_50724_) && (Integer)blockstate.m_61143_((Property)RespawnAnchorBlock.f_55833_) > 0 && RespawnAnchorBlock.m_55850_((Level)respawnWorld) || blockstate.m_204336_(BlockTags.f_13038_)) {
                                player.m_6027_((double)spawn.m_123341_() + 0.5, (double)(spawn.m_123342_() + 1), (double)spawn.m_123343_() + 0.5);
                                if (blockstate.m_60713_(Blocks.f_50724_)) {
                                    respawnWorld.m_7731_(spawn, (BlockState)blockstate.m_61124_((Property)RespawnAnchorBlock.f_55833_, (Comparable)Integer.valueOf((Integer)blockstate.m_61143_((Property)RespawnAnchorBlock.f_55833_) - 1)), 3);
                                }
                                if (Objects.equals(player.m_142081_(), UNION_UUID)) {
                                    player.m_183503_().m_6263_(null, (double)spawn.m_123341_() + 0.5, (double)spawn.m_123342_() + 1.5, (double)spawn.m_123343_() + 0.5, SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 0.5f);
                                    for (i = 0; i < 360; ++i) {
                                        if (i % 20 != 0) continue;
                                        respawnWorld.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, false, (double)spawn.m_123341_() + 0.5 + Math.cos(i) * 1.5, (double)spawn.m_123342_() + 1.5, (double)spawn.m_123343_() + 0.5 + Math.sin(i) * 1.5, 1, 0.0, 0.0, 0.0, 0.0);
                                    }
                                } else {
                                    player.m_183503_().m_6263_(null, (double)spawn.m_123341_() + 0.5, (double)spawn.m_123342_() + 1.5, (double)spawn.m_123343_() + 0.5, SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                    for (i = 0; i < 10; ++i) {
                                        respawnWorld.m_8624_(player, (ParticleOptions)ParticleTypes.f_123760_, false, (double)spawn.m_123341_() + 0.5, (double)(spawn.m_123342_() + 1), (double)spawn.m_123343_() + 0.5, (int)(player.m_21187_().nextDouble() * 10.0), (player.m_21187_().nextDouble() - 0.5) * 1.5, -player.m_21187_().nextDouble() + 1.0, (player.m_21187_().nextDouble() - 0.5) * 1.5, 0.0);
                                    }
                                }
                            } else {
                                System.out.println(player + " DOESN'T HAVE A SPAWN BLOCK");
                                player.m_5661_((Component)new TextComponent("Your spawn point was not found"), true);
                            }
                        } else {
                            System.out.println(player + " IS ATTEMPTING TO USE HOME TP IN A WRONG DIMENSION");
                            player.m_5661_((Component)new TextComponent("Home teleportation doesn't work across dimensions"), true);
                        }
                        player.m_36335_().m_41524_((Item)SkillCloaksItems.CONSTRUCTION_CLOAK.get(), 20);
                        player.m_36335_().m_41524_((Item)SkillCloaksItems.MAX_CLOAK.get(), 20);
                    } else {
                        System.out.println(player + " DOESN'T HAVE A SPAWN BLOCK");
                        player.m_5661_((Component)new TextComponent("Your spawn point was not found"), true);
                    }
                }
            }
            if (!ModList.get().isLoaded("lucent") && (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.FIREMAKING_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.MAX_CLOAK.get()).isPresent() && maxData.m_128451_(TAG_MAX_MODE) == 1)) {
                mainHandItemStack = player.m_21205_();
                offHandItemStack = player.m_21206_();
                slotInv = new SimpleContainer(new ItemStack[]{mainHandItemStack});
                slotInvOff = new SimpleContainer(new ItemStack[]{offHandItemStack});
                recipe = CloakAbilityPacket.getSmokingRecipe((Player)player, (Container)slotInv);
                recipeOff = CloakAbilityPacket.getSmokingRecipe((Player)player, (Container)slotInvOff);
                recipe0 = CloakAbilityPacket.getBlastingRecipe((Player)player, (Container)slotInv);
                recipeOff0 = CloakAbilityPacket.getBlastingRecipe((Player)player, (Container)slotInvOff);
                if (!(recipe != null && offHandItemStack.m_41720_().equals(Items.f_42409_) || recipeOff != null && mainHandItemStack.m_41720_().equals(Items.f_42409_) || recipe0 != null && offHandItemStack.m_41720_().equals(Items.f_42409_) || recipeOff0 != null && mainHandItemStack.m_41720_().equals(Items.f_42409_) || player.m_36335_().m_41519_((Item)SkillCloaksItems.FIREMAKING_CLOAK.get()) || player.m_36335_().m_41519_((Item)SkillCloaksItems.MAX_CLOAK.get()))) {
                    ServerLevel serverWorld = player.m_183503_();
                    if (Objects.equals(player.m_142081_(), JAPE_UUID)) {
                        for (int i = 0; i < 360; ++i) {
                            if (i % 20 != 0) continue;
                            serverWorld.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, player.m_20185_() + Math.cos(i) * 1.5, player.m_20186_() + 1.0, player.m_20189_() + Math.sin(i) * 1.5, 1, 0.0, 0.0, 0.0, (double)0.1f);
                        }
                        player.m_183503_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    } else {
                        player.m_183503_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    drop = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), new ItemStack((ItemLike)Items.f_42000_));
                    drop.m_20334_(0.0, 0.0, 0.0);
                    drop.m_32061_();
                    player.f_19853_.m_7967_((Entity)drop);
                    player.m_36335_().m_41524_((Item)SkillCloaksItems.FIREMAKING_CLOAK.get(), 20);
                    player.m_36335_().m_41524_((Item)SkillCloaksItems.MAX_CLOAK.get(), 20);
                }
            }
            if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.COOKING_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.MAX_CLOAK.get()).isPresent()) {
                mainHandItemStack = player.m_21205_();
                offHandItemStack = player.m_21206_();
                slotInv = new SimpleContainer(new ItemStack[]{mainHandItemStack});
                slotInvOff = new SimpleContainer(new ItemStack[]{offHandItemStack});
                recipe = CloakAbilityPacket.getSmokingRecipe((Player)player, (Container)slotInv);
                recipeOff = CloakAbilityPacket.getSmokingRecipe((Player)player, (Container)slotInvOff);
                if (recipe != null || recipeOff != null) {
                    if (offHandItemStack.m_41720_().equals(Items.f_42409_)) {
                        int size = mainHandItemStack.m_41613_();
                        for (int i = 0; i < size; ++i) {
                            if (!offHandItemStack.m_41720_().equals(Items.f_42409_) || offHandItemStack.m_41773_() > 63 || (result = recipe.m_5874_((Container)slotInv)).m_41619_()) continue;
                            mainHandItemStack.m_41774_(1);
                            drop = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), result);
                            drop.m_20334_(0.0, 0.0, 0.0);
                            drop.m_32061_();
                            player.f_19853_.m_7967_((Entity)drop);
                            offHandItemStack.m_41622_(1, (LivingEntity)player, holder -> holder.m_21166_(EquipmentSlot.OFFHAND));
                        }
                        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    if (mainHandItemStack.m_41720_().equals(Items.f_42409_)) {
                        int size = offHandItemStack.m_41613_();
                        for (int i = 0; i < size; ++i) {
                            if (!mainHandItemStack.m_41720_().equals(Items.f_42409_) || mainHandItemStack.m_41773_() > 63 || (result = recipeOff.m_5874_((Container)slotInv)).m_41619_()) continue;
                            offHandItemStack.m_41774_(1);
                            drop = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), result);
                            drop.m_20334_(0.0, 0.0, 0.0);
                            drop.m_32061_();
                            player.f_19853_.m_7967_((Entity)drop);
                            mainHandItemStack.m_41622_(1, (LivingEntity)player, holder -> holder.m_21166_(EquipmentSlot.MAINHAND));
                        }
                        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
            if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.SMITHING_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.MAX_CLOAK.get()).isPresent()) {
                mainHandItemStack = player.m_21205_();
                offHandItemStack = player.m_21206_();
                slotInv = new SimpleContainer(new ItemStack[]{mainHandItemStack});
                slotInvOff = new SimpleContainer(new ItemStack[]{offHandItemStack});
                recipe = CloakAbilityPacket.getBlastingRecipe((Player)player, (Container)slotInv);
                recipeOff = CloakAbilityPacket.getBlastingRecipe((Player)player, (Container)slotInvOff);
                if (recipe != null || recipeOff != null) {
                    if (offHandItemStack.m_41720_().equals(Items.f_42409_)) {
                        int size = mainHandItemStack.m_41613_();
                        for (int i = 0; i < size; ++i) {
                            if (!offHandItemStack.m_41720_().equals(Items.f_42409_) || offHandItemStack.m_41773_() > 63 || (result = recipe.m_5874_((Container)slotInv)).m_41619_()) continue;
                            mainHandItemStack.m_41774_(1);
                            drop = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), result);
                            drop.m_20334_(0.0, 0.0, 0.0);
                            drop.m_32061_();
                            player.f_19853_.m_7967_((Entity)drop);
                            offHandItemStack.m_41622_(1, (LivingEntity)player, holder -> holder.m_21166_(EquipmentSlot.OFFHAND));
                        }
                        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    if (mainHandItemStack.m_41720_().equals(Items.f_42409_)) {
                        int size = offHandItemStack.m_41613_();
                        for (int i = 0; i < size; ++i) {
                            if (!mainHandItemStack.m_41720_().equals(Items.f_42409_) || mainHandItemStack.m_41773_() > 63 || (result = recipeOff.m_5874_((Container)slotInv)).m_41619_()) continue;
                            offHandItemStack.m_41774_(1);
                            drop = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), result);
                            drop.m_20334_(0.0, 0.0, 0.0);
                            drop.m_32061_();
                            player.f_19853_.m_7967_((Entity)drop);
                            mainHandItemStack.m_41622_(1, (LivingEntity)player, holder -> holder.m_21166_(EquipmentSlot.MAINHAND));
                        }
                        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }
}

