/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncKeycardSettings {
    private BlockPos pos;
    private int signature;
    private boolean[] acceptedLevels;
    private boolean link;

    public SyncKeycardSettings() {
    }

    public SyncKeycardSettings(BlockPos pos, boolean[] acceptedLevels, int signature, boolean link) {
        this.pos = pos;
        this.acceptedLevels = acceptedLevels;
        this.signature = signature;
        this.link = link;
    }

    public static void encode(SyncKeycardSettings message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130130_(message.signature);
        buf.writeBoolean(message.link);
        for (int i = 0; i < 5; ++i) {
            buf.writeBoolean(message.acceptedLevels[i]);
        }
    }

    public static SyncKeycardSettings decode(FriendlyByteBuf buf) {
        SyncKeycardSettings message = new SyncKeycardSettings();
        message.pos = buf.m_130135_();
        message.signature = buf.m_130242_();
        message.link = buf.readBoolean();
        message.acceptedLevels = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            message.acceptedLevels[i] = buf.readBoolean();
        }
        return message;
    }

    public static void onMessage(SyncKeycardSettings message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            KeycardReaderBlockEntity be;
            boolean isOwner;
            BlockPos pos = message.pos;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockEntity patt1820$temp = player.f_19853_.m_7702_(pos);
            if (patt1820$temp instanceof KeycardReaderBlockEntity && ((isOwner = (be = (KeycardReaderBlockEntity)patt1820$temp).getOwner().isOwner((Player)player)) || ModuleUtils.isAllowed((IModuleInventory)be, (Entity)player))) {
                AbstractContainerMenu patt2149$temp;
                if (isOwner) {
                    be.setAcceptedLevels(message.acceptedLevels);
                    be.setSignature(message.signature);
                }
                if (message.link && (patt2149$temp = player.f_36096_) instanceof KeycardReaderMenu) {
                    KeycardReaderMenu keycardReaderContainer = (KeycardReaderMenu)patt2149$temp;
                    keycardReaderContainer.link();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

