/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetSpeakerBlockPacket;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class SpeakerBlockGui
extends Screen {
    private static final Component NARRATOR_TEXT = new TranslatableComponent("gui.supplementaries.speaker_block.chat_message");
    private static final Component CHAT_TEXT = new TranslatableComponent("gui.supplementaries.speaker_block.narrator_message");
    private static final Component DISTANCE_BLOCKS = new TranslatableComponent("gui.supplementaries.speaker_block.blocks");
    private static final Component VOLUME_TEXT = new TranslatableComponent("gui.supplementaries.speaker_block.volume");
    private EditBox commandTextField;
    private final SpeakerBlockTile tileSpeaker;
    private boolean narrator;
    private final String message;
    private Button modeBtn;
    private ForgeSlider volumeSlider;

    public SpeakerBlockGui(SpeakerBlockTile te) {
        super((Component)new TranslatableComponent("gui.supplementaries.speaker_block.edit"));
        this.tileSpeaker = te;
        this.narrator = this.tileSpeaker.narrator;
        this.message = this.tileSpeaker.message;
    }

    public static void open(SpeakerBlockTile te) {
        Minecraft.m_91087_().m_91152_((Screen)new SpeakerBlockGui(te));
    }

    public void m_96624_() {
        this.commandTextField.m_94120_();
    }

    private void updateMode() {
        if (this.narrator) {
            this.modeBtn.m_93666_(NARRATOR_TEXT);
        } else {
            this.modeBtn.m_93666_(CHAT_TEXT);
        }
    }

    private void toggleMode() {
        this.narrator = !this.narrator;
    }

    public void m_7856_() {
        assert (this.f_96541_ != null);
        this.f_96541_.f_91068_.m_90926_(true);
        int range = ServerConfigs.cached.SPEAKER_RANGE;
        double currentValue = this.tileSpeaker.volume * (double)range;
        this.volumeSlider = new ForgeSlider(this.f_96543_ / 2 - 75, this.f_96544_ / 4 + 80, 150, 20, VOLUME_TEXT, DISTANCE_BLOCKS, 1.0, (double)range, currentValue, 1.0, 1, true);
        this.m_7787_((GuiEventListener)this.volumeSlider);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120, 200, 20, CommonComponents.f_130655_, p_214266_1_ -> this.onDone()));
        this.modeBtn = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 75, this.f_96544_ / 4 + 50, 150, 20, CHAT_TEXT, p_214186_1_ -> {
            this.toggleMode();
            this.updateMode();
        }));
        if (!ServerConfigs.cached.SPEAKER_NARRATOR) {
            this.modeBtn.f_93623_ = false;
        }
        this.updateMode();
        this.commandTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 10, 200, 20, this.f_96539_){

            protected MutableComponent m_5646_() {
                return super.m_5646_();
            }
        };
        this.commandTextField.m_94144_(this.message);
        this.commandTextField.m_94199_(32);
        this.m_7787_((GuiEventListener)this.commandTextField);
        this.m_94718_((GuiEventListener)this.commandTextField);
        this.commandTextField.m_94178_(true);
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
        this.tileSpeaker.message = this.commandTextField.m_94155_();
        this.tileSpeaker.narrator = this.narrator;
        this.tileSpeaker.volume = this.volumeSlider.getValue();
        NetworkHandler.INSTANCE.sendToServer((Object)new ServerBoundSetSpeakerBlockPacket(this.tileSpeaker.m_58899_(), this.tileSpeaker.message, this.tileSpeaker.narrator, this.tileSpeaker.volume));
    }

    private void onDone() {
        this.tileSpeaker.m_6596_();
        this.f_96541_.m_91152_(null);
    }

    public void m_7379_() {
        this.onDone();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ != 257 && p_keyPressed_1_ != 335) {
            return false;
        }
        this.onDone();
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.volumeSlider.m_7691_(mouseX, mouseY);
        }
        return false;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        SpeakerBlockGui.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)40, (int)0xFFFFFF);
        this.volumeSlider.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.commandTextField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

