/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.supplementaries.common.block.IDynamicContainer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TrappedPresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.IColored;
import net.mehvahdjukaar.supplementaries.common.block.util.IPresentItemBehavior;
import net.mehvahdjukaar.supplementaries.common.inventories.TrappedPresentContainerMenu;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TrappedPresentBlockTile
extends OpeneableContainerBlockEntity
implements IColored,
IDynamicContainer {
    private long lastActivated = 0L;

    public TrappedPresentBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.TRAPPED_PRESENT_TILE.get(), pos, state, 1);
    }

    @Override
    public boolean canHoldItems() {
        return this.isPrimed();
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Nullable
    public DyeColor getColor() {
        return ((TrappedPresentBlock)this.m_58900_().m_60734_()).getColor();
    }

    public static boolean isPrimed(ItemStack stack) {
        CompoundTag com = stack.m_41783_();
        if (com != null) {
            CompoundTag tag = com.m_128469_("BlockEntityTag");
            return tag.m_128441_("Items");
        }
        return false;
    }

    public boolean isPrimed() {
        return (Boolean)this.m_58900_().m_61143_((Property)TrappedPresentBlock.PRIMED);
    }

    public void updateState(boolean primed) {
        if (!this.f_58857_.f_46443_ && this.isPrimed() != primed) {
            if (primed) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.PRESENT_PACK.get(), SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.95f);
            } else {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.PRESENT_BREAK.get(), SoundSource.BLOCKS, 0.75f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 1.2f);
            }
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PresentBlock.PACKED, (Comparable)Boolean.valueOf(primed)), 3);
        }
    }

    public boolean m_7525_(Player player) {
        return !this.isPrimed();
    }

    public InteractionResult interact(ServerPlayer player, BlockPos pos) {
        long time = player.f_19853_.m_46467_();
        if (this.isUnused() && Mth.m_14154_((float)(time - this.lastActivated)) > 10.0f) {
            if (this.m_7525_((Player)player)) {
                NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)this, (BlockPos)pos);
                PiglinAi.m_34873_((Player)player, (boolean)true);
            } else {
                this.detonate(player.m_183503_(), pos);
                this.lastActivated = time;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void detonate(ServerLevel level, BlockPos pos) {
        BlockSourceImpl blocksourceimpl = new BlockSourceImpl(level, pos);
        ItemStack stack = this.m_8020_(0);
        IPresentItemBehavior presentItemBehavior = TrappedPresentBlock.getPresentBehavior(stack);
        this.updateState(false);
        presentItemBehavior.trigger((BlockSource)blocksourceimpl, stack);
    }

    public Component m_6820_() {
        return new TranslatableComponent("gui.supplementaries.trapped_present");
    }

    @Override
    protected void updateBlockState(BlockState state, boolean b) {
    }

    @Override
    protected void playOpenSound(BlockState state) {
    }

    @Override
    protected void playCloseSound(BlockState state) {
    }

    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new TrappedPresentContainerMenu(id, player, (Container)this, this.f_58858_);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return PresentBlockTile.isAcceptableItem(stack);
    }

    public boolean m_7155_(int p_19235_, ItemStack p_19236_, @Nullable Direction p_19237_) {
        return false;
    }

    public boolean m_7157_(int p_19239_, ItemStack p_19240_, Direction p_19241_) {
        return false;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public ItemStack getPresentItem(ItemLike block2) {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        ItemStack itemstack = new ItemStack(block2);
        if (!compoundTag.m_128456_()) {
            itemstack.m_41700_("BlockEntityTag", (Tag)compoundTag);
        }
        if (this.m_8077_()) {
            itemstack.m_41714_(this.m_7770_());
        }
        return itemstack;
    }
}

