/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.configured;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ConfigHandler;
import net.mehvahdjukaar.supplementaries.integration.configured.CustomConfigScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class CustomConfigSelectScreen
extends ModConfigSelectionScreen {
    public static final ResourceLocation ICONS_TEXTURES = Textures.MISC_ICONS_TEXTURE;
    private static final Field FILE_ITEM_BUTTON;

    public CustomConfigSelectScreen(Screen parent, String displayName, ResourceLocation background, Map<ModConfig.Type, Set<ModConfig>> configMap) {
        super(parent, displayName, background, configMap);
    }

    public static void registerScreen() {
        ModContainer container = (ModContainer)ModList.get().getModContainerById("supplementaries").get();
        Map<ModConfig.Type, Set<ModConfig>> modConfigMap = CustomConfigSelectScreen.createConfigMap();
        container.registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, screen) -> new CustomConfigSelectScreen((Screen)screen, "\u00a76Supplementaries Configured", Textures.CONFIG_BACKGROUND, modConfigMap)));
    }

    private static Map<ModConfig.Type, Set<ModConfig>> createConfigMap() {
        HashMap<ModConfig.Type, Set<ModConfig>> modConfigMap = new HashMap<ModConfig.Type, Set<ModConfig>>();
        HashSet<ModConfig> s = new HashSet<ModConfig>();
        s.add(ConfigHandler.CLIENT_CONFIG_OBJECT);
        modConfigMap.put(ModConfig.Type.CLIENT, s);
        HashSet<ModConfig> s1 = new HashSet<ModConfig>();
        s1.add(ConfigHandler.REGISTRY_CONFIG_OBJECT);
        s1.add(ConfigHandler.SERVER_CONFIG_OBJECT);
        modConfigMap.put(ModConfig.Type.COMMON, s1);
        return modConfigMap;
    }

    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        super.constructEntries(entries);
        for (ListMenuScreen.Item i : entries) {
            if (!(i instanceof ModConfigSelectionScreen.FileItem)) continue;
            ModConfigSelectionScreen.FileItem item2 = (ModConfigSelectionScreen.FileItem)i;
            try {
                FILE_ITEM_BUTTON.setAccessible(true);
                FILE_ITEM_BUTTON.set(i, this.createModifyButton(this.getConfigFromLabel(item2.getLabel())));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private ModConfig getConfigFromLabel(String label) {
        if (label.contains("Common")) {
            return ConfigHandler.SERVER_CONFIG_OBJECT;
        }
        if (label.contains("Client")) {
            return ConfigHandler.CLIENT_CONFIG_OBJECT;
        }
        return ConfigHandler.REGISTRY_CONFIG_OBJECT;
    }

    private Button createModifyButton(ModConfig config) {
        String langKey = "configured.gui.modify";
        return new IconButton(0, 0, 33, 0, 60, (Component)new TranslatableComponent(langKey), onPress -> Minecraft.m_91087_().m_91152_((Screen)new CustomConfigScreen((Screen)this, (Component)new TextComponent("\u00a76Supplementaries Configured"), config, this.background)), (button, matrixStack, mouseX, mouseY) -> {
            if (button.m_198029_() && ConfigScreen.isPlayingGame() && !ConfigHelper.isConfiguredInstalledOnServer()) {
                this.m_96617_(matrixStack, this.f_96547_.m_92923_((FormattedText)new TranslatableComponent("configured.gui.not_installed"), Math.max(this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
            }
        });
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (ScreenUtil.isMouseWithin((int)(this.f_96543_ / 2 - 90), (int)2, (int)180, (int)16, (int)mouseX, (int)mouseY)) {
            this.m_96617_(poseStack, this.f_96547_.m_92923_((FormattedText)new TranslatableComponent("supplementaries.gui.info"), 200), mouseX, mouseY);
        }
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_) + 35;
        this.f_96542_.m_115218_(CustomConfigScreen.MAIN_ICON, this.f_96543_ / 2 + titleWidth / 2 - 17, 2);
        this.f_96542_.m_115218_(CustomConfigScreen.MAIN_ICON, this.f_96543_ / 2 - titleWidth / 2, 2);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin((int)(this.f_96543_ / 2 - 90), (int)2, (int)180, (int)16, (int)((int)mouseX), (int)((int)mouseY))) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/supplementaries"));
            this.m_5561_(style);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_7856_() {
        super.m_7856_();
        Button found = null;
        for (GuiEventListener c : this.m_6702_()) {
            Button button2;
            if (!(c instanceof Button) || (button2 = (Button)c).m_5711_() != 150) continue;
            found = button2;
        }
        if (found != null) {
            this.m_169411_((GuiEventListener)found);
        }
        int y = this.f_96544_ - 29;
        int centerX = this.f_96543_ / 2;
        this.m_142416_((GuiEventListener)new Button(centerX - 45, y, 90, 20, CommonComponents.f_130660_, button -> this.f_96541_.m_91152_(this.parent)));
        ButtonIcon patreon = ButtonIcon.linkButton((Screen)this, centerX - 45 - 22, y, 3, 1, this.getLink("https://www.patreon.com/user?u=53696377"), "Support me on Patreon :D");
        ButtonIcon kofi = ButtonIcon.linkButton((Screen)this, centerX - 45 - 44, y, 2, 2, this.getLink("https://ko-fi.com/mehvahdjukaar"), "Donate a Coffe");
        ButtonIcon curseforge = ButtonIcon.linkButton((Screen)this, centerX - 45 - 66, y, 1, 2, this.getLink("https://www.curseforge.com/minecraft/mc-mods/supplementaries"), "CurseForge Page");
        ButtonIcon github = ButtonIcon.linkButton((Screen)this, centerX - 45 - 88, y, 0, 2, this.getLink("https://github.com/MehVahdJukaar/Supplementaries/wiki"), "Mod Wiki");
        ButtonIcon discord = ButtonIcon.linkButton((Screen)this, centerX + 45 + 2, y, 1, 1, this.getLink("https://discord.com/invite/qdKRTDf8Cv"), "Mod Discord");
        ButtonIcon youtube = ButtonIcon.linkButton((Screen)this, centerX + 45 + 2 + 22, y, 0, 1, this.getLink("https://www.youtube.com/watch?v=LSPNAtAEn28&t=1s"), "Youtube Channel");
        ButtonIcon twitter = ButtonIcon.linkButton((Screen)this, centerX + 45 + 2 + 44, y, 2, 1, this.getLink("https://twitter.com/Supplementariez?s=09"), "Twitter Page");
        ButtonIcon akliz = ButtonIcon.linkButton((Screen)this, centerX + 45 + 2 + 66, y, 3, 2, this.getLink("https://www.akliz.net/supplementaries"), "Need a server? Get one with Akliz");
        this.m_142416_((GuiEventListener)kofi);
        this.m_142416_((GuiEventListener)akliz);
        this.m_142416_((GuiEventListener)patreon);
        this.m_142416_((GuiEventListener)curseforge);
        this.m_142416_((GuiEventListener)discord);
        this.m_142416_((GuiEventListener)youtube);
        this.m_142416_((GuiEventListener)github);
        this.m_142416_((GuiEventListener)twitter);
    }

    public String getLink(String original) {
        return CommonUtil.FESTIVITY.isAprilsFool() ? "https://www.youtube.com/watch?v=dQw4w9WgXcQ" : original;
    }

    static {
        Field temp = null;
        try {
            temp = ObfuscationReflectionHelper.findField(ModConfigSelectionScreen.FileItem.class, (String)"modifyButton");
        }
        catch (Exception exception) {
        }
        finally {
            FILE_ITEM_BUTTON = temp;
        }
    }

    public static class ButtonIcon
    extends Button {
        private static final int ICON_WIDTH = 14;
        private final Component label;
        private final int u;
        private final int v;

        public static ButtonIcon linkButton(Screen parent, int x, int y, int uInd, int vInd, String url, String tooltip) {
            Button.OnPress onPress = op -> {
                Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                parent.m_5561_(style);
            };
            Button.OnTooltip onTooltip = (button, poseStack, mouseX, mouseY) -> {
                if (button.m_198029_()) {
                    parent.m_96617_(poseStack, parent.getMinecraft().f_91062_.m_92923_((FormattedText)new TextComponent(tooltip), Math.max(parent.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                }
            };
            return new ButtonIcon(x, y, uInd * 14, vInd * 14, 20, TextComponent.f_131282_, onPress, onTooltip);
        }

        public ButtonIcon(int x, int y, int u, int v, int width, Component label, Button.OnPress onPress, Button.OnTooltip onTooltip) {
            super(x, y, width, 20, TextComponent.f_131282_, onPress, onTooltip);
            this.label = label;
            this.u = u;
            this.v = v;
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
            Minecraft mc = Minecraft.m_91087_();
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS_TEXTURES);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int contentWidth = 14 + mc.f_91062_.m_92852_((FormattedText)this.label);
            int iconX = (int)((double)this.f_93620_ + Math.ceil((float)(this.f_93618_ - contentWidth) / 2.0f));
            int iconY = (int)((double)this.f_93621_ + Math.ceil((float)(this.f_93618_ - 14) / 2.0f));
            float brightness = this.f_93623_ ? 1.0f : 0.5f;
            RenderSystem.m_157429_((float)brightness, (float)brightness, (float)brightness, (float)this.f_93625_);
            ButtonIcon.m_93143_((PoseStack)poseStack, (int)iconX, (int)iconY, (int)this.m_93252_(), (float)this.u, (float)this.v, (int)14, (int)14, (int)64, (int)64);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            int textColor = this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24;
            ButtonIcon.m_93243_((PoseStack)poseStack, (Font)mc.f_91062_, (Component)this.label, (int)(iconX + 14), (int)(iconY + 1), (int)textColor);
        }
    }
}

