/*
 * Decompiled with CFR 0.152.
 */
package mca.client.render.layer;

import mca.client.model.VillagerEntityModelMCA;
import mca.client.render.layer.VillagerLayer;
import mca.client.resources.ColorPalette;
import mca.entity.Infectable;
import mca.entity.VillagerLike;
import mca.entity.ai.Genetics;
import mca.entity.ai.Traits;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class SkinLayer<T extends Mob>
extends VillagerLayer<T, VillagerEntityModelMCA<T>> {
    public SkinLayer(RenderLayerParent<T, VillagerEntityModelMCA<T>> renderer, VillagerEntityModelMCA<T> model) {
        super(renderer, model);
    }

    @Override
    protected ResourceLocation getSkin(T villager) {
        Genetics genetics = ((VillagerLike)villager).getGenetics();
        int skin = (int)Math.min(4.0f, Math.max(0.0f, genetics.getGene(Genetics.SKIN) * 5.0f));
        return this.cached(String.format("%s:skins/skin/%s/%d.png", "mca", genetics.getGender().getStrName(), skin), ResourceLocation::new);
    }

    @Override
    protected float[] getColor(T villager) {
        float albinism = ((VillagerLike)villager).getTraits().hasTrait(Traits.Trait.ALBINISM) ? 0.1f : 1.0f;
        return ColorPalette.SKIN.getColor(((VillagerLike)villager).getGenetics().getGene(Genetics.MELANIN) * albinism, ((VillagerLike)villager).getGenetics().getGene(Genetics.HEMOGLOBIN) * albinism, ((Infectable)villager).getInfectionProgress());
    }
}

