/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai;

import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import mca.Config;
import mca.entity.VillagerLike;
import mca.util.network.datasync.CDataManager;
import mca.util.network.datasync.CDataParameter;
import mca.util.network.datasync.CParameter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;

public class Traits {
    private static final CDataParameter<CompoundTag> TRAITS = CParameter.create("traits", new CompoundTag());
    private Random random;
    private final VillagerLike<?> entity;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(TRAITS);
    }

    public Traits(VillagerLike<?> entity) {
        this.entity = entity;
        this.random = new Random(entity.asEntity().f_19853_.f_46441_.nextLong());
    }

    public Set<Trait> getTraits() {
        return ((CompoundTag)this.entity.getTrackedValue(TRAITS)).m_128431_().stream().map(Trait::valueOf).collect(Collectors.toSet());
    }

    public Set<Trait> getInheritedTraits() {
        return this.getTraits().stream().filter(t -> t.inherit * Config.getInstance().traitInheritChance < this.random.nextFloat()).collect(Collectors.toSet());
    }

    public boolean hasTrait(Trait trait) {
        return ((CompoundTag)this.entity.getTrackedValue(TRAITS)).m_128441_(trait.name());
    }

    public void addTrait(Trait trait) {
        CompoundTag traits = ((CompoundTag)this.entity.getTrackedValue(TRAITS)).m_6426_();
        traits.m_128379_(trait.name(), true);
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void removeTrait(Trait trait) {
        CompoundTag traits = ((CompoundTag)this.entity.getTrackedValue(TRAITS)).m_6426_();
        traits.m_128473_(trait.name());
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void randomize() {
        float total = (float)Arrays.stream(Trait.values()).mapToDouble(tr -> tr.chance).sum();
        for (Trait t : Trait.values()) {
            float chance = Config.getInstance().traitChance / total * t.chance;
            if (!(this.random.nextFloat() < chance)) continue;
            this.addTrait(t);
        }
    }

    public void inherit(Traits from) {
        for (Trait t : from.getInheritedTraits()) {
            this.addTrait(t);
        }
    }

    public void inherit(Traits from, long seed) {
        Random old = this.random;
        this.random = new Random(seed);
        this.inherit(from);
        this.random = old;
    }

    public float getVerticalScaleFactor() {
        return this.hasTrait(Trait.DWARFISM) ? 0.65f : 1.0f;
    }

    public float getHorizontalScaleFactor() {
        return this.hasTrait(Trait.DWARFISM) ? 0.85f : 1.0f;
    }

    public static enum Trait {
        COLOR_BLIND(1.0f, 0.5f),
        HETEROCHROMIA(1.0f, 2.0f),
        LACTOSE_INTOLERANCE(1.0f, 1.0f),
        COELIAC_DISEASE(1.0f, 1.0f),
        DIABETES(1.0f, 1.0f),
        DWARFISM(1.0f, 1.0f),
        ALBINISM(1.0f, 1.0f),
        VEGETARIAN(1.0f, 0.0f),
        ELECTRIFIED(0.0f, 0.0f),
        SIRBEN(0.025f, 1.0f);

        private final float chance;
        private final float inherit;

        private Trait(float chance, float inherit) {
            this.chance = chance;
            this.inherit = inherit;
        }

        public Component getName() {
            return new TranslatableComponent("trait." + this.name().toLowerCase(Locale.ENGLISH));
        }

        public Component getDescription() {
            return new TranslatableComponent("traitDescription." + this.name().toLowerCase(Locale.ENGLISH));
        }
    }
}

