/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.relationship;

import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import mca.entity.ai.relationship.CompassionateEntity;
import mca.entity.ai.relationship.Gender;
import mca.entity.ai.relationship.MarriageState;
import mca.entity.ai.relationship.RelationshipType;
import mca.entity.ai.relationship.family.FamilyTree;
import mca.entity.ai.relationship.family.FamilyTreeNode;
import mca.server.world.data.PlayerSaveData;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntityRelationship {
    default public Gender getGender() {
        return Gender.MALE;
    }

    public FamilyTree getFamilyTree();

    @NotNull
    public FamilyTreeNode getFamilyEntry();

    public Stream<Entity> getFamily(int var1, int var2);

    public Stream<Entity> getParents();

    public Stream<Entity> getSiblings();

    public Optional<Entity> getSpouse();

    default public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite, RelationshipType type, Entity victim) {
        if (type == RelationshipType.STRANGER) {
            return;
        }
        if (type == RelationshipType.SELF) {
            this.getParents().forEach(parent -> EntityRelationship.of(parent).ifPresent(r -> r.onTragedy(cause, burialSite, RelationshipType.CHILD, victim)));
            this.getSiblings().forEach(sibling -> EntityRelationship.of(sibling).ifPresent(r -> r.onTragedy(cause, burialSite, RelationshipType.SIBLING, victim)));
            this.getSpouse().flatMap(EntityRelationship::of).ifPresent(r -> r.onTragedy(cause, burialSite, RelationshipType.SPOUSE, victim));
        }
        if ((type == RelationshipType.SPOUSE || type == RelationshipType.SELF) && this.getMarriageState().isMarried()) {
            this.endMarriage(MarriageState.WIDOW);
        }
    }

    public void marry(Entity var1);

    public void endMarriage(MarriageState var1);

    public MarriageState getMarriageState();

    public Optional<UUID> getSpouseUuid();

    public Optional<Component> getSpouseName();

    default public boolean isMarried() {
        return !this.getSpouseUuid().orElse(Util.f_137441_).equals(Util.f_137441_);
    }

    default public boolean isMarriedTo(UUID uuid) {
        return this.getSpouseUuid().orElse(Util.f_137441_).equals(uuid);
    }

    public static Optional<EntityRelationship> of(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return Optional.ofNullable(PlayerSaveData.get(player.m_183503_(), entity.m_142081_()));
        }
        if (entity instanceof CompassionateEntity) {
            CompassionateEntity compassionateEntity = (CompassionateEntity)entity;
            return Optional.of(compassionateEntity.getRelationships());
        }
        return Optional.empty();
    }
}

