/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.interaction;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mca.MCA;
import mca.entity.VillagerEntityMCA;
import mca.entity.interaction.gifts.GiftPredicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class InteractionPredicate {
    private final int chance;
    @Nullable
    private final GiftPredicate.Condition condition;
    final List<String> conditionKeys;

    public static InteractionPredicate fromJson(JsonObject json) {
        int chance = 0;
        @Nullable GiftPredicate.Condition condition = null;
        LinkedList<String> conditionKeys = new LinkedList<String>();
        for (Map.Entry entry : json.entrySet()) {
            if ("chance".equals(entry.getKey())) {
                chance = GsonHelper.m_13897_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                continue;
            }
            if (GiftPredicate.CONDITION_TYPES.containsKey(entry.getKey())) {
                GiftPredicate.Condition parsed = GiftPredicate.CONDITION_TYPES.get(entry.getKey()).parse((JsonElement)entry.getValue());
                conditionKeys.add((String)entry.getKey());
                if (condition == null) {
                    condition = parsed;
                    continue;
                }
                condition = condition.and(parsed);
                continue;
            }
            MCA.LOGGER.warn("Interaction predicate " + (String)entry.getKey() + " does not exist!");
        }
        return new InteractionPredicate(chance, condition, conditionKeys);
    }

    public InteractionPredicate(int chance, @Nullable GiftPredicate.Condition condition, List<String> conditionKeys) {
        this.chance = chance;
        this.condition = condition;
        this.conditionKeys = conditionKeys;
    }

    public boolean test(VillagerEntityMCA villager, ServerPlayer player) {
        return this.condition != null && this.condition.test(villager, ItemStack.f_41583_, player);
    }

    public int getChance() {
        return this.chance;
    }

    public List<String> getConditionKeys() {
        return this.conditionKeys;
    }
}

