/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.interaction.gifts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mca.entity.VillagerEntityMCA;
import mca.entity.interaction.gifts.GiftPredicate;
import mca.entity.interaction.gifts.Response;
import mca.resources.data.analysis.IntAnalysis;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GiftType {
    static final List<GiftType> REGISTRY = new ArrayList<GiftType>();
    private final ResourceLocation id;
    private int priority;
    private final List<GiftPredicate> conditions;
    private final Map<Item, Integer> items;
    private final Map<TagKey<Item>, Integer> tags;
    private int fail;
    private int good;
    private int better;
    private final Map<Response, String> responses;

    public static GiftType fromJson(ResourceLocation id, JsonObject json) {
        ArrayList<GiftPredicate> conditions = new ArrayList<GiftPredicate>();
        GsonHelper.m_13832_((JsonObject)json, (String)"conditions", (JsonArray)new JsonArray()).forEach(element -> conditions.add(GiftPredicate.fromJson(GsonHelper.m_13918_((JsonElement)element, (String)"condition"))));
        HashMap<Item, Integer> items = new HashMap<Item, Integer>();
        HashMap<TagKey<Item>, Integer> tags = new HashMap<TagKey<Item>, Integer>();
        GsonHelper.m_13930_((JsonObject)json, (String)"items").entrySet().forEach(element -> {
            String string = (String)element.getKey();
            Integer satisfaction = ((JsonElement)element.getValue()).getAsInt();
            if (string.charAt(0) == '#') {
                ResourceLocation identifier = new ResourceLocation(string.substring(1));
                TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)identifier);
                if (tag != null) {
                    tags.put(tag, satisfaction);
                } else if (identifier.m_135827_().equals("mca")) {
                    throw new JsonSyntaxException("Unknown item tag '" + identifier + "'");
                }
            } else {
                ResourceLocation identifier = new ResourceLocation(string);
                Optional item = Registry.f_122827_.m_6612_(identifier);
                if (item.isPresent()) {
                    items.put((Item)item.get(), satisfaction);
                } else if (identifier.m_135827_().equals("mca")) {
                    throw new JsonSyntaxException("Unknown item '" + identifier + "'");
                }
            }
        });
        int priority = GsonHelper.m_13824_((JsonObject)json, (String)"priority", (int)0);
        JsonObject thresholds = GsonHelper.m_13841_((JsonObject)json, (String)"thresholds", (JsonObject)new JsonObject());
        int fail = GsonHelper.m_13824_((JsonObject)thresholds, (String)"fail", (int)0);
        int good = GsonHelper.m_13824_((JsonObject)thresholds, (String)"good", (int)10);
        int better = GsonHelper.m_13824_((JsonObject)thresholds, (String)"better", (int)20);
        JsonObject responsesJson = GsonHelper.m_13841_((JsonObject)json, (String)"responses", (JsonObject)new JsonObject());
        Map<Response, String> responses = Stream.of(Response.values()).collect(Collectors.toMap(Function.identity(), response -> GsonHelper.m_13851_((JsonObject)responsesJson, (String)response.name().toLowerCase(Locale.ENGLISH), (String)response.getDefaultDialogue())));
        return new GiftType(id, priority, conditions, items, tags, fail, good, better, responses);
    }

    public static Stream<GiftType> allMatching(ItemStack stack) {
        return REGISTRY.stream().filter(type -> type.matches(stack));
    }

    public static Optional<GiftType> bestMatching(VillagerEntityMCA recipient, ItemStack stack, ServerPlayer player) {
        int max = GiftType.allMatching(stack).mapToInt(a -> a.priority).max().orElse(0);
        Optional<GiftType> worst = GiftType.allMatching(stack).filter(a -> a.priority == max).filter(a -> a.getResponse(a.getSatisfactionFor(recipient, stack, player).getTotal()) == Response.FAIL).max(Comparator.comparingDouble(a -> a.getSatisfactionFor(recipient, stack, player).getTotal().intValue()));
        if (worst.isPresent()) {
            return worst;
        }
        return GiftType.allMatching(stack).filter(a -> a.priority == max).max(Comparator.comparingDouble(a -> a.getSatisfactionFor(recipient, stack, player).getTotal().intValue()));
    }

    public static Optional<GiftType> getGiftType(ResourceLocation id) {
        return REGISTRY.stream().filter(p -> p.id.equals((Object)id)).findFirst();
    }

    private static Map<Response, String> getDefaultDialogues() {
        return Arrays.stream(Response.values()).collect(Collectors.toMap(r -> r, Response::getDefaultDialogue));
    }

    public GiftType(Item item, int satisfaction, ResourceLocation extendFrom) {
        this(item, satisfaction, GiftType.getDefaultDialogues());
        Optional<GiftType> type = GiftType.getGiftType(extendFrom);
        type.ifPresent(this::extendFrom);
    }

    public GiftType(Item item, int satisfaction, Map<Response, String> responses) {
        this(Registry.f_122827_.m_7981_((Object)item), 0, new LinkedList<GiftPredicate>(), Collections.singletonMap(item, satisfaction), Collections.emptyMap(), 0, 10, 20, responses);
    }

    public GiftType(ResourceLocation id, int priority, List<GiftPredicate> conditions, Map<Item, Integer> items, Map<TagKey<Item>, Integer> tags, int fail, int good, int better, Map<Response, String> responses) {
        this.id = id;
        this.priority = priority;
        this.conditions = conditions;
        this.items = items;
        this.tags = tags;
        this.fail = fail;
        this.good = good;
        this.better = better;
        this.responses = responses;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<GiftPredicate> getConditions() {
        return this.conditions;
    }

    public Map<Response, String> getResponses() {
        return this.responses;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(ItemStack stack) {
        if (this.items.keySet().stream().anyMatch(i -> i == stack.m_41720_())) return true;
        if (!this.tags.keySet().stream().anyMatch(arg_0 -> ((ItemStack)stack).m_204117_(arg_0))) return false;
        return true;
    }

    public IntAnalysis getSatisfactionFor(VillagerEntityMCA recipient, ItemStack stack, ServerPlayer player) {
        IntAnalysis analysis = new IntAnalysis();
        Optional<Integer> value = this.items.entrySet().stream().filter(i -> i.getKey() == stack.m_41720_()).findFirst().map(Map.Entry::getValue);
        int base = value.orElseGet(() -> this.tags.entrySet().stream().filter(i -> stack.m_204117_((TagKey)i.getKey())).findFirst().map(Map.Entry::getValue).orElse(0));
        analysis.add("base", base);
        for (GiftPredicate c : this.conditions) {
            int val = c.getSatisfactionFor(recipient, stack, player);
            if (!c.test(recipient, stack, player)) continue;
            analysis.add(c.getConditionKeys().get(0), val);
        }
        return analysis;
    }

    public Response getResponse(int satisfaction) {
        return satisfaction <= this.fail ? Response.FAIL : (satisfaction <= this.good ? Response.GOOD : (satisfaction <= this.better ? Response.BETTER : Response.BEST));
    }

    public String getDialogueFor(Response response) {
        return this.responses.get((Object)response);
    }

    public void extendFrom(GiftType extendingType) {
        this.conditions.addAll(extendingType.getConditions());
        this.responses.clear();
        this.responses.putAll(extendingType.getResponses());
        this.priority = extendingType.priority;
        this.fail = extendingType.fail;
        this.good = extendingType.good;
        this.better = extendingType.better;
    }
}

