/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.features;

import java.util.List;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.minecraft.class_1074;
import org.apache.commons.lang3.text.WordUtils;

public enum FeatureFlags {
    SEPARATE_HARDWARE_SAMPLERS(() -> true, () -> true),
    HIGHER_SHADOWCOLOR(() -> true, () -> true),
    CUSTOM_IMAGES(() -> true, IrisRenderSystem::supportsImageLoadStore),
    PER_BUFFER_BLENDING(() -> true, IrisRenderSystem::supportsBufferBlending),
    COMPUTE_SHADERS(() -> true, IrisRenderSystem::supportsCompute),
    ENTITY_TRANSLUCENT(() -> true, () -> true),
    SSBO(() -> true, IrisRenderSystem::supportsSSBO),
    UNKNOWN(() -> false, () -> false);

    private final BooleanSupplier irisRequirement;
    private final BooleanSupplier hardwareRequirement;

    private FeatureFlags(BooleanSupplier booleanSupplier, BooleanSupplier booleanSupplier2) {
        this.irisRequirement = booleanSupplier;
        this.hardwareRequirement = booleanSupplier2;
    }

    public static String getInvalidStatus(List<FeatureFlags> list) {
        FeatureFlags[] featureFlagsArray;
        boolean bl = false;
        boolean bl2 = false;
        for (FeatureFlags featureFlags : featureFlagsArray = list.toArray(new FeatureFlags[0])) {
            bl2 |= !featureFlags.irisRequirement.getAsBoolean();
            bl |= !featureFlags.hardwareRequirement.getAsBoolean();
        }
        if (bl2) {
            if (bl) {
                return class_1074.method_4662((String)"iris.unsupported.irisorpc", (Object[])new Object[0]);
            }
            return class_1074.method_4662((String)"iris.unsupported.iris", (Object[])new Object[0]);
        }
        if (bl) {
            return class_1074.method_4662((String)"iris.unsupported.pc", (Object[])new Object[0]);
        }
        return null;
    }

    public String getHumanReadableName() {
        return WordUtils.capitalize((String)this.name().replace("_", " ").toLowerCase());
    }

    public boolean isUsable() {
        return this.irisRequirement.getAsBoolean() && this.hardwareRequirement.getAsBoolean();
    }

    public static boolean isInvalid(String string) {
        try {
            return !FeatureFlags.valueOf(string.toUpperCase(Locale.US)).isUsable();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
    }

    public static FeatureFlags getValue(String string) {
        try {
            return FeatureFlags.valueOf(string.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return UNKNOWN;
        }
    }
}

