/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.coderbot.iris.vendored.joml.Matrix3x2d;

public class Matrix3x2dStack
extends Matrix3x2d
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private Matrix3x2d[] mats;
    private int curr;

    public Matrix3x2dStack(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("stackSize must be >= 1");
        }
        this.mats = new Matrix3x2d[n - 1];
        for (int i = 0; i < this.mats.length; ++i) {
            this.mats[i] = new Matrix3x2d();
        }
    }

    public Matrix3x2dStack() {
    }

    public Matrix3x2dStack clear() {
        this.curr = 0;
        this.identity();
        return this;
    }

    public Matrix3x2dStack pushMatrix() {
        if (this.curr == this.mats.length) {
            throw new IllegalStateException("max stack size of " + (this.curr + 1) + " reached");
        }
        this.mats[this.curr++].set(this);
        return this;
    }

    public Matrix3x2dStack popMatrix() {
        if (this.curr == 0) {
            throw new IllegalStateException("already at the buttom of the stack");
        }
        this.set(this.mats[--this.curr]);
        return this;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.curr;
        for (int i = 0; i < this.curr; ++i) {
            n = 31 * n + this.mats[i].hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof Matrix3x2dStack) {
            Matrix3x2dStack matrix3x2dStack = (Matrix3x2dStack)object;
            if (this.curr != matrix3x2dStack.curr) {
                return false;
            }
            for (int i = 0; i < this.curr; ++i) {
                if (this.mats[i].equals(matrix3x2dStack.mats[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.curr);
        for (int i = 0; i < this.curr; ++i) {
            objectOutput.writeObject(this.mats[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        super.readExternal(objectInput);
        this.curr = objectInput.readInt();
        this.mats = new Matrix3x2dStack[this.curr];
        for (int i = 0; i < this.curr; ++i) {
            Matrix3x2d matrix3x2d = new Matrix3x2d();
            matrix3x2d.readExternal(objectInput);
            this.mats[i] = matrix3x2d;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Matrix3x2dStack matrix3x2dStack = (Matrix3x2dStack)super.clone();
        Matrix3x2d[] matrix3x2dArray = new Matrix3x2d[this.mats.length];
        for (int i = 0; i < this.mats.length; ++i) {
            matrix3x2dArray[i] = (Matrix3x2d)this.mats[i].clone();
        }
        matrix3x2dStack.mats = matrix3x2dArray;
        return matrix3x2dStack;
    }
}

