/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.core;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.core.config.ModernFixEarlyConfig;
import org.embeddedt.modernfix.core.config.Option;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.world.ThreadDumper;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ModernFixMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE_ROOT = "org.embeddedt.modernfix.mixin.";
    public final Logger logger = LogManager.getLogger((String)"ModernFix");
    public ModernFixEarlyConfig config = null;
    public static ModernFixMixinPlugin instance;

    public ModernFixMixinPlugin() {
        boolean firstConfig;
        ModernFixPlatformHooks.getCustomModOptions();
        boolean bl = firstConfig = instance == null;
        if (firstConfig) {
            instance = this;
            try {
                this.config = ModernFixEarlyConfig.load(new File("./config/modernfix-mixins.properties"));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load configuration file for ModernFix", e);
            }
            this.logger.info("Loaded configuration file for ModernFix: {} options available, {} override(s) found", (Object)this.config.getOptionCount(), (Object)this.config.getOptionOverrideCount());
            this.config.getOptionMap().values().forEach(option -> {
                if (option.isOverridden()) {
                    Object source = "[unknown]";
                    if (option.isUserDefined()) {
                        source = "user configuration";
                    } else if (option.isModDefined()) {
                        source = "mods [" + String.join((CharSequence)", ", option.getDefiningMods()) + "]";
                    }
                    this.logger.warn("Option '{}' overriden (by {}) to '{}'", (Object)option.getName(), source, (Object)option.isEnabled());
                }
            });
            if (ModernFixEarlyConfig.OPTIFINE_PRESENT) {
                this.logger.fatal("OptiFine detected. Use of ModernFix with OptiFine is not supported due to its impact on launch time and breakage of Forge features.");
            }
            try {
                Class.forName("sun.misc.Unsafe").getDeclaredMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
            }
            catch (NullPointerException | ReflectiveOperationException e) {
                this.logger.info("Applying Nashorn fix");
                Properties properties = System.getProperties();
                properties.setProperty("nashorn.args", properties.getProperty("nashorn.args", "") + " --anonymous-classes=false");
            }
            ModernFixPlatformHooks.injectPlatformSpecificHacks();
            if (instance.isOptionEnabled("feature.spam_thread_dump.ThreadDumper")) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        while (true) {
                            ModernFixMixinPlugin.this.logger.error("------ DEBUG THREAD DUMP (occurs every 60 seconds) ------");
                            ModernFixMixinPlugin.this.logger.error(ThreadDumper.obtainThreadDump());
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }
        }
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!(mixinClassName = ModernFixEarlyConfig.sanitize(mixinClassName)).startsWith(MIXIN_PACKAGE_ROOT)) {
            this.logger.error("Expected mixin '{}' to start with package root '{}', treating as foreign and disabling!", (Object)mixinClassName, (Object)MIXIN_PACKAGE_ROOT);
            return false;
        }
        String mixin = mixinClassName.substring(MIXIN_PACKAGE_ROOT.length());
        if (!instance.isOptionEnabled(mixin)) {
            return false;
        }
        String disabledBecauseMod = ModernFixMixinPlugin.instance.config.getPermanentlyDisabledMixins().get(mixin);
        return disabledBecauseMod == null;
    }

    public boolean isOptionEnabled(String mixin) {
        Option option = ModernFixMixinPlugin.instance.config.getEffectiveOptionForMixin(mixin);
        if (option == null) {
            String msg = "No rules matched mixin '{}', treating as foreign and disabling!";
            if (ModernFixPlatformHooks.isDevEnv()) {
                this.logger.error(msg, (Object)mixin);
            } else {
                this.logger.debug(msg, (Object)mixin);
            }
            return false;
        }
        return option.isEnabled();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        ModernFixPlatformHooks.applyASMTransformers(mixinClassName, targetClass);
    }
}

