/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.config.serializers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.core.config.file.serializers.DeserializeResult;
import mezz.jei.core.config.file.serializers.IConfigValueSerializer;
import net.minecraft.class_124;

public class ChatFormattingSerializer
implements IConfigValueSerializer<List<class_124>> {
    public static final ChatFormattingSerializer INSTANCE = new ChatFormattingSerializer();

    private ChatFormattingSerializer() {
    }

    @Override
    public String serialize(List<class_124> value) {
        return value.stream().map(class_124::method_537).collect(Collectors.joining(" "));
    }

    @Override
    public DeserializeResult<List<class_124>> deserialize(String string) {
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.isEmpty()) {
            return new DeserializeResult<List<class_124>>(List.of());
        }
        ArrayList<String> errors = new ArrayList<String>();
        String[] strings = string.split(" ");
        List result = Arrays.stream(strings).mapMulti((s, c) -> {
            class_124 chatFormatting = class_124.method_533((String)s);
            if (chatFormatting != null) {
                c.accept(chatFormatting);
            } else {
                errors.add("No Chat Formatting found for name: '%s'".formatted(s));
            }
        }).toList();
        return new DeserializeResult<List<class_124>>(result, errors);
    }

    @Override
    public String getValidValuesDescription() {
        EnumSet<class_124> validFormatting = EnumSet.allOf(class_124.class);
        validFormatting.remove(class_124.field_1070);
        ArrayList<class_124> validColors = new ArrayList<class_124>();
        ArrayList<class_124> validFormats = new ArrayList<class_124>();
        for (class_124 chatFormatting : validFormatting) {
            if (chatFormatting.method_543()) {
                validColors.add(chatFormatting);
                continue;
            }
            if (!chatFormatting.method_542()) continue;
            validFormats.add(chatFormatting);
        }
        return "A chat formatting string.\nUse these formatting colors:\n%s\nWith these formatting options:\n%s".formatted(this.serialize((List<class_124>)validColors), this.serialize((List<class_124>)validFormats));
    }
}

