/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.jei.info;

import java.util.Objects;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.common.gui.textures.Textures;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class IngredientInfoRecipeCategory
implements IRecipeCategory<IJeiIngredientInfoRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final class_2561 localizedName;

    public IngredientInfoRecipeCategory(IGuiHelper guiHelper, Textures textures) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        this.icon = textures.getInfoIcon();
        this.slotBackground = guiHelper.getSlotDrawable();
        this.localizedName = class_2561.method_43471((String)"gui.jei.category.itemInformation");
    }

    @Override
    public RecipeType<IJeiIngredientInfoRecipe> getRecipeType() {
        return RecipeTypes.INFORMATION;
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void draw(IJeiIngredientInfoRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
        boolean xPos = false;
        int yPos = this.slotBackground.getHeight() + 4;
        class_310 minecraft = class_310.method_1551();
        for (class_5348 descriptionLine : recipe.getDescription()) {
            minecraft.field_1772.method_27528(poseStack, class_2477.method_10517().method_30934(descriptionLine), (float)xPos, (float)yPos, -16777216);
            Objects.requireNonNull(minecraft.field_1772);
            yPos += 9 + 2;
        }
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IJeiIngredientInfoRecipe recipe, IFocusGroup focuses) {
        int xPos = 72;
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, xPos, 1).setBackground(this.slotBackground, -1, -1);
        IIngredientAcceptor<?> outputSlotBuilder = builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT);
        for (ITypedIngredient<?> typedIngredient : recipe.getIngredients()) {
            IngredientInfoRecipeCategory.addIngredient(typedIngredient, inputSlotBuilder);
            IngredientInfoRecipeCategory.addIngredient(typedIngredient, outputSlotBuilder);
        }
    }

    private static <T> void addIngredient(ITypedIngredient<T> typedIngredient, IIngredientAcceptor<?> slotBuilder) {
        slotBuilder.addIngredient(typedIngredient.getType(), typedIngredient.getIngredient());
    }
}

