/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.line;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class LinedChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final int bitsPerSide;
    private final class_5250 displayName;
    private final class_5250 multiLineDisplayName;
    private final class_2960 iconName;

    LinedChiselMode(int bitsPerSide, class_5250 displayName, class_5250 multiLineDisplayName, class_2960 iconName) {
        this.bitsPerSide = bitsPerSide;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(class_1657 playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> class_243.method_24954((class_2382)face.method_10153().method_10163()), class_2350::method_10153, false);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                mutator.inWorldMutableStream().forEach(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    }
                });
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(class_1657 playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(class_1657 playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> class_243.method_24954((class_2382)face.method_10163()), Function.identity(), true);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            class_2338 heightPos;
            IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                return ClickProcessingState.DEFAULT;
            }
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir()).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.method_7337()) {
                if (!playerEntity.method_7337()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir()).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().method_26204().method_9518()));
            }
            if (missingBitCount == 0 && (heightPos = new class_2338(mutator.getInWorldEndPoint())).method_10264() >= context.getWorld().method_31600()) {
                class_5250 component = class_2561.method_43469((String)"build.tooHigh", (Object[])new Object[]{context.getWorld().method_31600() - 1}).method_27692(class_124.field_1061);
                playerEntity.method_43496((class_2561)component);
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(class_1657 playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(class_1657 playerEntity, IChiselingContext context, Function<class_2350, class_243> placementFacingAdapter, Function<class_2350, class_2350> iterationAdaptor, boolean airOnly) {
        class_239 rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.method_17783() != class_239.class_240.field_1332 || !(rayTraceResult instanceof class_3965)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        class_3965 blockRayTraceResult = (class_3965)rayTraceResult;
        class_243 hitVector = blockRayTraceResult.method_17784().method_1019(placementFacingAdapter.apply(blockRayTraceResult.method_17780()).method_18805((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        class_243 hitBlockPosVector = class_243.method_24954((class_2382)new class_2338(hitVector));
        class_243 inBlockHitVector = hitVector.method_1020(hitBlockPosVector);
        class_243 inBlockBitVector = inBlockHitVector.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide());
        class_2350 iterationDirection = iterationAdaptor.apply(blockRayTraceResult.method_17780());
        switch (iterationDirection) {
            case field_11033: {
                this.includeDownAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case field_11036: {
                this.includeUpAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case field_11043: {
                this.includeNorthAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case field_11035: {
                this.includeSouthAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case field_11039: {
                this.includeWestAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case field_11034: {
                this.includeEastAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
            }
        }
        return Optional.empty();
    }

    private void includeDownAxis(IChiselingContext context, boolean airOnly, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int yOff = 0;
            while ((double)yOff < inBlockBitVector.method_10214()) {
                class_243 targetBit = inBlockBitVector.method_1023(0.0, (double)yOff, 0.0);
                class_243 inWorldOffset = this.clampVectorToBlock(targetBit.method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                class_243 inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++yOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
                class_243 targetBit;
                class_243 inWorldOffset;
                class_243 inWorldTarget;
                int yOff = 0;
                while ((double)yOff < inBlockBitVector.method_10214() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.method_1023((double)xOff, (double)yOff, (double)zOff)).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++yOff;
                }
            }
        }
    }

    private void includeUpAxis(IChiselingContext context, boolean airOnly, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int yOff = 0;
            while ((double)yOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.method_10214()) {
                class_243 targetBit = inBlockBitVector.method_1023(0.0, (double)(-yOff), 0.0);
                class_243 inWorldOffset = this.clampVectorToBlock(targetBit.method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                class_243 inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++yOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
                class_243 targetBit;
                class_243 inWorldOffset;
                class_243 inWorldTarget;
                int yOff = 0;
                while ((double)yOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.method_10214() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.method_1023((double)xOff, (double)(-yOff), (double)zOff)).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++yOff;
                }
            }
        }
    }

    private void includeNorthAxis(IChiselingContext context, boolean airOnly, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int zOff = 0;
            while ((double)zOff < inBlockBitVector.method_10215()) {
                class_243 targetBit = inBlockBitVector.method_1023(0.0, 0.0, (double)zOff);
                class_243 inWorldOffset = this.clampVectorToBlock(targetBit.method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                class_243 inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++zOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                class_243 targetBit;
                class_243 inWorldOffset;
                class_243 inWorldTarget;
                int zOff = 0;
                while ((double)zOff < inBlockBitVector.method_10215() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.method_1023((double)xOff, (double)yOff, (double)zOff)).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++zOff;
                }
            }
        }
    }

    private void includeSouthAxis(IChiselingContext context, boolean airOnly, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int zOff = 0;
            while ((double)zOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.method_10215()) {
                class_243 targetBit = inBlockBitVector.method_1023(0.0, 0.0, (double)(-zOff));
                class_243 inWorldOffset = this.clampVectorToBlock(targetBit.method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                class_243 inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++zOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                class_243 targetBit;
                class_243 inWorldOffset;
                class_243 inWorldTarget;
                int zOff = 0;
                while ((double)zOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.method_10215() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.method_1023((double)xOff, (double)yOff, (double)(-zOff))).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++zOff;
                }
            }
        }
    }

    private void includeWestAxis(IChiselingContext context, boolean airOnly, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int xOff = 0;
            while ((double)xOff < inBlockBitVector.method_10216()) {
                class_243 targetBit = inBlockBitVector.method_1023((double)xOff, 0.0, 0.0);
                class_243 inWorldOffset = this.clampVectorToBlock(targetBit.method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                class_243 inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++xOff;
            }
            return;
        }
        for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                class_243 targetBit;
                class_243 inWorldOffset;
                class_243 inWorldTarget;
                int xOff = 0;
                while ((double)xOff < inBlockBitVector.method_10216() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.method_1023((double)xOff, (double)yOff, (double)zOff)).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++xOff;
                }
            }
        }
    }

    private void includeEastAxis(IChiselingContext context, boolean airOnly, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int xOff = 0;
            while ((double)xOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.method_10216()) {
                class_243 targetBit = inBlockBitVector.method_1023((double)(-xOff), 0.0, 0.0);
                class_243 inWorldOffset = this.clampVectorToBlock(targetBit.method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                class_243 inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++xOff;
            }
            return;
        }
        for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                class_243 targetBit;
                class_243 inWorldOffset;
                class_243 inWorldTarget;
                int xOff = 0;
                while ((double)xOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.method_10216() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.method_1019(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.method_1023((double)(-xOff), (double)yOff, (double)zOff)).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getBlockInformation().isAir() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++xOff;
                }
            }
        }
    }

    private class_243 clampVectorToBlock(class_243 v) {
        return new class_243(v.method_10216() < 0.0 ? 0.0 : (v.method_10216() >= 1.0 ? (double)0.999f : v.method_10216()), v.method_10214() < 0.0 ? 0.0 : (v.method_10214() >= 1.0 ? (double)0.999f : v.method_10214()), v.method_10215() < 0.0 ? 0.0 : (v.method_10215() >= 1.0 ? (double)0.999f : v.method_10215()));
    }

    @Override
    public class_265 getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return class_259.method_1073();
        }
        return VoxelShapeManager.getInstance().get((IAreaAccessor)context.getMutator().get(), CollisionType.ALL);
    }

    @Override
    @NotNull
    public class_2960 getIcon() {
        return this.iconName;
    }

    @Override
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public class_5250 getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.LINE);
    }
}

