/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.font;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.class_1159;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

public class GuiBagFontRenderer
extends class_327 {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();
    private final class_327 fontRenderer;
    private final int offsetX;
    private final int offsetY;
    private final float scale;

    public GuiBagFontRenderer(class_327 src, int bagStackSize) {
        super(src.field_1997, true);
        this.fontRenderer = src;
        if (bagStackSize < 100) {
            this.scale = 1.0f;
            this.offsetX = 0;
            this.offsetY = 0;
        } else {
            this.scale = 0.75f;
            this.offsetX = 3;
            this.offsetY = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int method_1720(class_4587 matrixStack, @NotNull String text, float x, float y, int color) {
        try {
            text = this.convertText(text);
            matrixStack.method_22903();
            matrixStack.method_22905(this.scale, this.scale, this.scale);
            x /= this.scale;
            y /= this.scale;
            int n = this.fontRenderer.method_1720(matrixStack, text, x += (float)this.offsetX, y += (float)this.offsetY, color);
            return n;
        }
        finally {
            matrixStack.method_22909();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int method_1729(class_4587 matrixStack, @NotNull String text, float x, float y, int color) {
        try {
            text = this.convertText(text);
            matrixStack.method_22903();
            matrixStack.method_22905(this.scale, this.scale, this.scale);
            x /= this.scale;
            y /= this.scale;
            int n = this.fontRenderer.method_1729(matrixStack, text, x += (float)this.offsetX, y += (float)this.offsetY, color);
            return n;
        }
        finally {
            matrixStack.method_22909();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int method_27520(@NotNull String text, float x, float y, int color, @NotNull class_1159 matrix, boolean dropShadow, boolean p_228078_7_) {
        class_4587 stack = new class_4587();
        class_1159 original = new class_1159(matrix);
        try {
            stack.method_23760().method_23761().method_22672(matrix);
            stack.method_22905(this.scale, this.scale, this.scale);
            x /= this.scale;
            y /= this.scale;
            int n = super.method_27520(text, x += (float)this.offsetX, y += (float)this.offsetY, color, stack.method_23760().method_23761(), dropShadow, p_228078_7_);
            return n;
        }
        finally {
            matrix.method_22668();
            matrix.method_22672(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int method_27521(@NotNull String text, float x, float y, int color, boolean dropShadow, @NotNull class_1159 matrix, @NotNull class_4597 buffer, boolean transparentIn, int colorBackgroundIn, int packedLight) {
        class_4587 stack = new class_4587();
        class_1159 original = new class_1159(matrix);
        try {
            stack.method_23760().method_23761().method_22672(matrix);
            stack.method_22905(this.scale, this.scale, this.scale);
            x /= this.scale;
            y /= this.scale;
            int n = super.method_27521(this.convertText(text), x += (float)this.offsetX, y += (float)this.offsetY, color, dropShadow, stack.method_23760().method_23761(), buffer, transparentIn, colorBackgroundIn, packedLight);
            return n;
        }
        finally {
            matrix.method_22668();
            matrix.method_22672(original);
        }
    }

    public int method_1727(@NotNull String text) {
        text = this.convertText(text);
        return this.fontRenderer.method_1727(text);
    }

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return GuiBagFontRenderer.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + GuiBagFontRenderer.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    private String convertText(String text) {
        try {
            long value = Long.parseLong(text);
            return GuiBagFontRenderer.format(value);
        }
        catch (NumberFormatException e) {
            return text;
        }
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }
}

