/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.stateinfo.additional;

import com.communi.suggestu.scena.core.fluid.FluidInformation;
import com.communi.suggestu.scena.core.registries.IPlatformRegistryManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.api.variant.state.IStateVariantProvider;
import mod.chiselsandbits.blockinformation.BlockInformation;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import org.jetbrains.annotations.NotNull;

public final class StateVariantManager
implements IStateVariantManager {
    private static final StateVariantManager INSTANCE = new StateVariantManager();
    private final Map<Supplier<class_2248>, IStateVariantProvider> preBakeProviders = new ConcurrentHashMap<Supplier<class_2248>, IStateVariantProvider>();
    private final Map<class_2248, IStateVariantProvider> providers = new ConcurrentHashMap<class_2248, IStateVariantProvider>();

    public static StateVariantManager getInstance() {
        return INSTANCE;
    }

    private StateVariantManager() {
    }

    @Override
    public IStateVariantManager registerProvider(Supplier<class_2248> block, IStateVariantProvider provider) {
        this.preBakeProviders.put(block, provider);
        return this;
    }

    private void bakeProviders() {
        if (!this.providers.isEmpty()) {
            return;
        }
        this.preBakeProviders.forEach((block, provider) -> this.providers.put((class_2248)block.get(), (IStateVariantProvider)provider));
        this.preBakeProviders.clear();
    }

    @Override
    public Optional<IStateVariant> getStateVariant(class_2680 blockState, Optional<class_2586> blockEntity) {
        this.bakeProviders();
        if (!this.providers.containsKey(blockState.method_26204())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(blockState.method_26204())).flatMap(provider -> provider.getStateVariant(blockState, blockEntity)).map(variant -> new WrappingStateVariant(blockState.method_26204(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(class_3610 fluidStateIn) {
        this.bakeProviders();
        if (!this.providers.containsKey(fluidStateIn.method_15759().method_26204())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(fluidStateIn.method_15759().method_26204())).flatMap(provider -> provider.getStateVariant(fluidStateIn)).map(variant -> new WrappingStateVariant(fluidStateIn.method_15759().method_26204(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(class_2680 blockState, class_1799 itemStack) {
        this.bakeProviders();
        if (!this.providers.containsKey(blockState.method_26204())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(blockState.method_26204())).flatMap(provider -> provider.getStateVariant(blockState, itemStack)).map(variant -> new WrappingStateVariant(blockState.method_26204(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(FluidInformation fluidInformation) {
        this.bakeProviders();
        if (!this.providers.containsKey(fluidInformation.fluid().method_15785().method_15759().method_26204())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(fluidInformation.fluid().method_15785().method_15759().method_26204())).flatMap(provider -> provider.getStateVariant(fluidInformation)).map(variant -> new WrappingStateVariant(fluidInformation.fluid().method_15785().method_15759().method_26204(), (IStateVariant)variant));
    }

    @Override
    public Collection<IBlockInformation> getAllDefaultVariants(class_2680 state) {
        this.bakeProviders();
        if (!this.providers.containsKey(state.method_26204())) {
            return Collections.emptyList();
        }
        return Optional.of(this.providers.get(state.method_26204())).map(provider -> provider.getAllDefaultVariants(state)).stream().flatMap(Collection::stream).map(variant -> new WrappingStateVariant(state.method_26204(), (IStateVariant)variant)).map(variant -> new BlockInformation(state, Optional.of(variant))).collect(Collectors.toSet());
    }

    @Override
    public class_2487 serializeNBT(IStateVariant variant) {
        if (!(variant instanceof WrappingStateVariant)) {
            throw new IllegalArgumentException("additionalStateInfo must be a WrappingStateVariant");
        }
        WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)variant;
        this.bakeProviders();
        class_2248 block = wrappingStateVariant.sourceBlock();
        class_2487 tag = new class_2487();
        tag.method_10582("block", IPlatformRegistryManager.getInstance().getBlockRegistry().getKey((Object)block).toString());
        tag.method_10566("variant", (class_2520)this.providers.get(block).serializeNBT(wrappingStateVariant.delegate()));
        return tag;
    }

    @Override
    public IStateVariant deserializeNBT(class_2487 tag) {
        this.bakeProviders();
        Optional block = IPlatformRegistryManager.getInstance().getBlockRegistry().getValue(new class_2960(tag.method_10558("block")));
        if (block.isEmpty()) {
            throw new IllegalStateException("Missing block from variant!");
        }
        IStateVariant delegate = this.providers.get(block.get()).deserializeNBT(tag.method_10562("variant"));
        return new WrappingStateVariant((class_2248)block.get(), delegate);
    }

    @Override
    public void serializeInto(class_2540 packetBuffer, IStateVariant variant) {
        if (!(variant instanceof WrappingStateVariant)) {
            throw new IllegalArgumentException("additionalStateInfo must be a WrappingStateVariant");
        }
        WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)variant;
        this.bakeProviders();
        packetBuffer.method_10812(IPlatformRegistryManager.getInstance().getBlockRegistry().getKey((Object)wrappingStateVariant.sourceBlock()));
        this.providers.get(wrappingStateVariant.sourceBlock()).serializeInto(packetBuffer, wrappingStateVariant.delegate());
    }

    @Override
    public IStateVariant deserializeFrom(class_2540 packetBuffer) {
        this.bakeProviders();
        Optional block = IPlatformRegistryManager.getInstance().getBlockRegistry().getValue(packetBuffer.method_10810());
        if (block.isEmpty()) {
            throw new IllegalStateException("Missing block from variant!");
        }
        IStateVariant stateVariant = this.providers.get(block.get()).deserializeFrom(packetBuffer);
        return new WrappingStateVariant((class_2248)block.get(), stateVariant);
    }

    @Override
    public Optional<class_1799> getItemStack(IBlockInformation blockInformation) {
        this.bakeProviders();
        if (!this.providers.containsKey(blockInformation.getBlockState().method_26204())) {
            return Optional.empty();
        }
        return blockInformation.getVariant().flatMap(stateVariant -> this.providers.get(blockInformation.getBlockState().method_26204()).getItemStack((IStateVariant)stateVariant));
    }

    @Override
    public Optional<FluidInformation> getFluidInformation(IBlockInformation blockInformation, long amount) {
        this.bakeProviders();
        if (!this.providers.containsKey(blockInformation.getBlockState().method_26204())) {
            return Optional.empty();
        }
        return blockInformation.getVariant().flatMap(variant -> this.providers.get(blockInformation.getBlockState().method_26204()).getFluidInformation((IStateVariant)variant, amount));
    }

    @Override
    public Optional<class_2561> getName(IBlockInformation blockInformation) {
        this.bakeProviders();
        if (!this.providers.containsKey(blockInformation.getBlockState().method_26204())) {
            return Optional.empty();
        }
        return blockInformation.getVariant().flatMap(variant -> this.providers.get(blockInformation.getBlockState().method_26204()).getName((IStateVariant)variant));
    }

    public Optional<IStateVariant> unwrapVariant(Optional<IStateVariant> variant) {
        return variant.map(v -> {
            if (v instanceof WrappingStateVariant) {
                WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)v;
                return wrappingStateVariant.delegate();
            }
            return v;
        });
    }

    private record WrappingStateVariant(class_2248 sourceBlock, IStateVariant delegate) implements IStateVariant
    {
        private static final Comparator<IStateVariant> VARIANT_COMPARATOR = Comparator.comparing(variant -> variant.getClass().getName()).thenComparing(Comparator.naturalOrder());

        @Override
        public int compareTo(@NotNull IStateVariant o) {
            if (o instanceof WrappingStateVariant) {
                WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)o;
                return VARIANT_COMPARATOR.compare(this.delegate, wrappingStateVariant.delegate);
            }
            return -1;
        }

        @Override
        public IStateVariant createSnapshot() {
            return new WrappingStateVariant(this.sourceBlock, (IStateVariant)this.delegate.createSnapshot());
        }
    }
}

