/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import com.communi.suggestu.scena.core.dist.Dist;
import com.communi.suggestu.scena.core.dist.DistExecutor;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LanguageHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    private LanguageHandler() {
    }

    public static String format(String inputKey, Object ... args) {
        String key = inputKey.toLowerCase(Locale.US);
        StringBuilder result = new StringBuilder();
        class_5348.class_5245 consumer = pContent -> {
            result.append(pContent);
            return Optional.empty();
        };
        if (args.length == 0) {
            class_2561.method_43471((String)key).method_10851().method_27659(consumer);
        } else {
            class_2561.method_43469((String)key, (Object[])args).method_10851().method_27659(consumer);
        }
        return result.isEmpty() ? key : result.toString();
    }

    public static String translateKey(String key) {
        return LanguageCache.getInstance().translateKey(key.toLowerCase(Locale.US));
    }

    public static void loadLangPath(String path) {
        LanguageCache.getInstance().load(path);
    }

    private static class LanguageCache {
        private static LanguageCache instance;
        private Map<String, String> languageMap;

        private LanguageCache() {
            String fileLoc = "assets/chiselsandbits/lang/%s.json";
            this.load("assets/chiselsandbits/lang/%s.json");
        }

        private void load(String path) {
            InputStream is;
            String defaultLocale = "en_us";
            String locale = (String)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> class_310.method_1551() == null || class_310.method_1551().field_1690 == null ? "en_us" : class_310.method_1551().field_1690.field_1883);
            if (locale == null) {
                locale = "en_us";
            }
            if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, locale))) == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, "en_us"));
            }
            try {
                this.languageMap = (Map)new Gson().fromJson((Reader)new InputStreamReader(Objects.requireNonNull(is), StandardCharsets.UTF_8), new TypeToken<Map<String, String>>(){}.getType());
                is.close();
            }
            catch (IOException | NullPointerException e) {
                LOGGER.error("Could not load language.", (Throwable)e);
            }
        }

        private static LanguageCache getInstance() {
            return instance == null ? (instance = new LanguageCache()) : instance;
        }

        private String translateKey(String key) {
            boolean isMCloaded = false;
            if (isMCloaded) {
                return class_2477.method_10517().method_4679(key);
            }
            String res = this.languageMap.get(key);
            return res == null ? key : res;
        }
    }
}

