/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft;

import com.sun.jna.NativeLibrary;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import jopenvr.JOpenVRLibrary;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.vivecraft.VRMixinConfigPopup;
import org.vivecraft.VRState;
import org.vivecraft.Xplat;
import org.vivecraft.utils.Utils;

public class VRMixinConfig
implements IMixinConfigPlugin {
    protected static boolean asked = false;
    private static boolean unpackedNatives = false;

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void onLoad(String mixinPackage) {
    }

    private static boolean unpackPlatformNatives() {
        String s = System.getProperty("os.name").toLowerCase();
        String s1 = System.getProperty("os.arch").toLowerCase();
        Object s2 = "win";
        if (s.contains("linux")) {
            s2 = "linux";
        } else if (s.contains("mac")) {
            s2 = "osx";
        }
        if (!s.contains("mac")) {
            s2 = s1.contains("64") ? (String)s2 + "64" : (String)s2 + "32";
        }
        try {
            Utils.unpackNatives((String)s2);
        }
        catch (Exception e) {
            System.out.println("Native path not found");
            return false;
        }
        if (!new File("openvr/" + (String)s2).exists()) {
            System.out.println("Path does not exist, skipping VR!");
            return false;
        }
        String s3 = new File("openvr/" + (String)s2).getAbsolutePath();
        System.out.println("Adding OpenVR search path: " + s3);
        NativeLibrary.addSearchPath((String)"openvr_api", (String)s3);
        return true;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!Xplat.isModLoadedSuccess()) {
            LogManager.getLogger().log(Level.WARN, "not loading '" + mixinClassName + "' because mod failed to load completely");
            return false;
        }
        if (mixinClassName.contains("NoSodium") && (Xplat.isModLoaded("sodium") || Xplat.isModLoaded("rubidium"))) {
            return false;
        }
        return VRState.isVR;
    }

    static {
        Properties properties = new Properties();
        try {
            boolean needToAsk;
            Path file = Xplat.getConfigPath("vivecraft-config.properties");
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
            properties.load(Files.newInputStream(file, new OpenOption[0]));
            boolean bl = needToAsk = !properties.containsKey("askEveryStartup") || Boolean.parseBoolean(properties.getProperty("askEveryStartup"));
            if (properties.containsKey("vrStatus") && !needToAsk) {
                VRState.isVR = Boolean.parseBoolean(properties.getProperty("vrStatus"));
            } else if (Xplat.isDedicatedServer()) {
                VRState.isVR = false;
                properties.setProperty("vrStatus", String.valueOf(VRState.isVR));
            } else if (!asked) {
                VRMixinConfigPopup.askVR(properties, file, !properties.containsKey("askEveryStartup"));
            }
            if (!unpackedNatives && VRState.isVR) {
                VRMixinConfig.unpackPlatformNatives();
                VRState.isVR = !JOpenVRLibrary.isErrored();
                unpackedNatives = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

