/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.blaze3d.pipeline;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1159;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.vivecraft.extensions.RenderTargetExtension;
import org.vivecraft.mixin.blaze3d.systems.RenderSystemAccessor;

@Debug(export=true)
@Mixin(value={class_276.class})
public abstract class RenderTargetMixin
implements RenderTargetExtension {
    @Unique
    private int texid = -1;
    @Unique
    public String name = "Default";
    @Unique
    private boolean linearFilter;
    @Unique
    private boolean useStencil = false;
    @Shadow
    public int field_1476;
    @Shadow
    protected int field_1474;
    @Shadow
    public boolean field_1478;
    @Shadow
    public int field_1482;
    @Shadow
    public int field_1481;
    @Shadow
    public int field_1477;
    @Shadow
    public int field_1480;
    @Shadow
    protected int field_1475;

    @Shadow
    public abstract void method_1242();

    @Shadow
    public abstract void method_35610();

    @Shadow
    public abstract void method_1230(boolean var1);

    @Shadow
    public abstract void method_1239();

    @Shadow
    public abstract void method_1232(int var1);

    @Shadow
    public abstract void method_1240();

    @Overwrite
    public void method_22594(int pWidth, int pHeight, boolean p_83960_) {
        this.blitToScreen(0, pWidth, pHeight, 0, p_83960_, 0.0f, 0.0f, false);
    }

    @Override
    public int getDepthBufferId() {
        return this.field_1474;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setUseStencil(boolean useStencil) {
        this.useStencil = useStencil;
    }

    @Override
    public boolean getUseStencil() {
        return this.useStencil;
    }

    @Override
    public void clearWithColor(float r, float g, float b, float a, boolean isMac) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.method_22595(true);
        RenderSystem.clearColor((float)r, (float)g, (float)b, (float)a);
        int i = 16384;
        if (this.field_1478) {
            RenderSystem.clearDepth((double)1.0);
            i |= 0x100;
        }
        RenderSystem.clear((int)i, (boolean)isMac);
        this.method_1240();
    }

    @Override
    public void setTextid(int texid) {
        this.texid = texid;
    }

    @Override
    public void isLinearFilter(boolean linearFilter) {
        this.linearFilter = linearFilter;
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("\n");
        if (this.name != null) {
            stringbuilder.append("Name:   " + this.name).append("\n");
        }
        stringbuilder.append("Size:   " + this.field_1480 + " x " + this.field_1477).append("\n");
        stringbuilder.append("FB ID:  " + this.field_1476).append("\n");
        stringbuilder.append("Tex ID: " + this.field_1475).append("\n");
        return stringbuilder.toString();
    }

    @Redirect(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/TextureUtil;generateTextureId()I", ordinal=0), method={"createBuffers"})
    public int genTextureId() {
        if (this.texid == -1) {
            return TextureUtil.generateTextureId();
        }
        return this.texid;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_texImage2D(IIIIIIIILjava/nio/IntBuffer;)V", ordinal=0), method={"createBuffers"}, index=2)
    public int modifyTexImage2DInternalformat(int internalformat) {
        return this.useStencil ? 36013 : internalformat;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_texImage2D(IIIIIIIILjava/nio/IntBuffer;)V", ordinal=0), method={"createBuffers"}, index=6)
    public int modifyTexImage2DFormat(int format) {
        return this.useStencil ? 34041 : format;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_texImage2D(IIIIIIIILjava/nio/IntBuffer;)V", ordinal=0), method={"createBuffers"}, index=7)
    public int modifyTexImage2DType(int type) {
        return this.useStencil ? 36269 : type;
    }

    @ModifyConstant(method={"createBuffers"}, constant={@Constant(intValue=9728)})
    public int changeTextPar(int i) {
        return this.linearFilter ? 9729 : i;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_glFramebufferTexture2D(IIIII)V", ordinal=1), method={"createBuffers"}, index=1)
    public int modifyGlFramebufferTexture2DAttachment(int attachment) {
        return this.useStencil ? 33306 : attachment;
    }

    @Overwrite
    private void method_22595(boolean bl) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._glBindFramebuffer((int)36160, (int)this.field_1476);
        if (bl) {
            RenderSystem.viewport((int)0, (int)0, (int)this.field_1480, (int)this.field_1477);
        }
    }

    @Override
    public void blitToScreen(class_5944 instance, int left, int width, int height, int top, boolean disableBlend, float xCropFactor, float yCropFactor, boolean keepAspect) {
        RenderSystem.assertOnGameThreadOrInit();
        if (!RenderSystem.isInInitPhase()) {
            RenderSystem.recordRenderCall(() -> this._blitToScreen(instance, left, width, height, top, disableBlend, xCropFactor, yCropFactor, keepAspect));
        } else {
            this._blitToScreen(instance, left, width, height, top, disableBlend, xCropFactor, yCropFactor, keepAspect);
        }
    }

    @Override
    public void blitFovReduction(class_5944 instance, int width, int height) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.viewport((int)0, (int)0, (int)width, (int)height);
        RenderSystem.disableBlend();
        class_310 minecraft = class_310.method_1551();
        RenderSystem.setShaderTexture((int)0, (int)this.field_1475);
        if (instance == null) {
            instance = minecraft.field_1773.field_29403;
            instance.method_34583("DiffuseSampler", (Object)this.field_1475);
        } else {
            for (int k = 0; k < RenderSystemAccessor.getShaderTextures().length; ++k) {
                int l = RenderSystem.getShaderTexture((int)k);
                instance.method_34583("Sampler" + k, (Object)l);
            }
        }
        class_1159 matrix4f = class_1159.method_4933((float)width, (float)(-height), (float)1000.0f, (float)3000.0f);
        RenderSystem.setProjectionMatrix((class_1159)matrix4f);
        if (instance.field_29470 != null) {
            instance.field_29470.method_1250(class_1159.method_24021((float)0.0f, (float)0.0f, (float)-2000.0f));
        }
        if (instance.field_29471 != null) {
            instance.field_29471.method_1250(matrix4f);
        }
        instance.method_34586();
        float f = width;
        float g = height;
        float h = (float)this.field_1480 / (float)this.field_1482;
        float k = (float)this.field_1477 / (float)this.field_1481;
        class_289 tesselator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tesselator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, instance.method_35786());
        if (instance.method_35786() == class_290.field_1585) {
            bufferBuilder.method_22912(0.0, (double)g, 0.0).method_22913(0.0f, 0.0f).method_1344();
            bufferBuilder.method_22912((double)f, (double)g, 0.0).method_22913(h, 0.0f).method_1344();
            bufferBuilder.method_22912((double)f, 0.0, 0.0).method_22913(h, k).method_1344();
            bufferBuilder.method_22912(0.0, 0.0, 0.0).method_22913(0.0f, k).method_1344();
        } else if (instance.method_35786() == class_290.field_1575) {
            bufferBuilder.method_22912(0.0, (double)g, 0.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
            bufferBuilder.method_22912((double)f, (double)g, 0.0).method_22913(h, 0.0f).method_1336(255, 255, 255, 255).method_1344();
            bufferBuilder.method_22912((double)f, 0.0, 0.0).method_22913(h, k).method_1336(255, 255, 255, 255).method_1344();
            bufferBuilder.method_22912(0.0, 0.0, 0.0).method_22913(0.0f, k).method_1336(255, 255, 255, 255).method_1344();
        } else {
            throw new IllegalStateException("Unexpected vertex format " + instance.method_35786());
        }
        class_286.method_43437((class_287.class_7433)bufferBuilder.method_1326());
        instance.method_34585();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private void _blitToScreen(class_5944 instance, int left, int width, int height, int top, boolean bl, float xCropFactor, float yCropFactor, boolean keepAspect) {
        RenderSystem.assertOnGameThreadOrInit();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.viewport((int)left, (int)top, (int)width, (int)height);
        if (bl) {
            RenderSystem.disableBlend();
        }
        class_310 minecraft = class_310.method_1551();
        float f = (float)width / (float)height;
        float f1 = (float)this.field_1480 / (float)this.field_1477;
        float f2 = width;
        float f3 = height;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (keepAspect) {
            if (f > f1) {
                float f6 = (float)width / (float)this.field_1480;
                f4 = 0.0f;
                f2 = width;
                f5 = (float)height / 2.0f - (float)this.field_1477 / 2.0f * f6;
                f3 = (float)height / 2.0f + (float)this.field_1477 / 2.0f * f6;
            } else {
                float f10 = (float)height / (float)this.field_1477;
                f4 = (float)width / 2.0f - (float)this.field_1480 / 2.0f * f10;
                f2 = (float)width / 2.0f + (float)this.field_1480 / 2.0f * f10;
                f5 = 0.0f;
                f3 = height;
            }
        }
        float f11 = width;
        float f7 = height;
        float f8 = (float)this.field_1480 / (float)this.field_1482;
        float f9 = (float)this.field_1477 / (float)this.field_1481;
        if (instance == null) {
            instance = minecraft.field_1773.field_29403;
            instance.method_34583("DiffuseSampler", (Object)this.field_1475);
        } else {
            for (int k = 0; k < RenderSystemAccessor.getShaderTextures().length; ++k) {
                int l = RenderSystem.getShaderTexture((int)k);
                instance.method_34583("Sampler" + k, (Object)l);
            }
        }
        class_1159 matrix4f = class_1159.method_4933((float)width, (float)(-height), (float)1000.0f, (float)3000.0f);
        RenderSystem.setProjectionMatrix((class_1159)matrix4f);
        if (instance.field_29470 != null) {
            instance.field_29470.method_1250(class_1159.method_24021((float)0.0f, (float)0.0f, (float)-2000.0f));
        }
        if (instance.field_29471 != null) {
            instance.field_29471.method_1250(matrix4f);
        }
        instance.method_34586();
        class_289 tesselator = RenderSystem.renderThreadTesselator();
        class_287 bufferbuilder = tesselator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, instance.method_35786());
        bufferbuilder.method_22912((double)f4, (double)f3, 0.0).method_22913(xCropFactor, yCropFactor).method_1336(255, 255, 255, 255).method_1344();
        bufferbuilder.method_22912((double)f2, (double)f3, 0.0).method_22913(f8 - xCropFactor, yCropFactor).method_1336(255, 255, 255, 255).method_1344();
        bufferbuilder.method_22912((double)f2, (double)f5, 0.0).method_22913(f8 - xCropFactor, f9 - yCropFactor).method_1336(255, 255, 255, 255).method_1344();
        bufferbuilder.method_22912((double)f4, (double)f5, 0.0).method_22913(xCropFactor, f9 - yCropFactor).method_1336(255, 255, 255, 255).method_1344();
        class_286.method_43437((class_287.class_7433)bufferbuilder.method_1326());
        instance.method_34585();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }
}

