/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.gui.screens;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.VRState;
import org.vivecraft.Xplat;

@Mixin(value={class_442.class})
public abstract class TitleScreenMixin
extends class_437 {
    private final Properties vrConfig = new Properties();
    private final Path vrConfigPath = Xplat.getConfigPath("vivecraft-config.properties");
    private boolean showRestart = false;
    private boolean showError = false;
    private class_339 firstButton;
    private class_4185 vrModeButton;

    protected TitleScreenMixin(class_2561 component) {
        super(component);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/TitleScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;", shift=At.Shift.AFTER, ordinal=1)}, method={"createNormalMenuOptions"})
    public void initFullGame(CallbackInfo ci) {
        this.addVRModeButton();
    }

    @Inject(at={@At(value="TAIL")}, method={"createDemoMenuOptions"})
    public void initDemo(CallbackInfo ci) {
        this.addVRModeButton();
    }

    private void addVRModeButton() {
        for (class_4068 widget : this.field_33816) {
            if (!(widget instanceof class_339)) continue;
            this.firstButton = (class_339)widget;
            break;
        }
        try {
            if (!Files.exists(this.vrConfigPath, new LinkOption[0])) {
                Files.createFile(this.vrConfigPath, new FileAttribute[0]);
            }
            this.vrConfig.load(Files.newInputStream(this.vrConfigPath, new OpenOption[0]));
            if (!this.vrConfig.containsKey("vrStatus")) {
                this.vrConfig.setProperty("vrStatus", String.valueOf(VRState.isVR));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String vrMode = Boolean.parseBoolean(this.vrConfig.getProperty("vrStatus")) ? "VR" : "NONVR";
        this.vrModeButton = new class_4185(this.field_22789 / 2 + 104, this.field_22790 / 4 + 72, 56, 20, (class_2561)class_2561.method_43470((String)(this.getIcon() + vrMode)), button -> {
            String newMode;
            this.showError = false;
            if (button.method_25369().getString().endsWith("NONVR")) {
                this.vrConfig.setProperty("vrStatus", String.valueOf(true));
                newMode = "VR";
            } else {
                this.vrConfig.setProperty("vrStatus", String.valueOf(false));
                newMode = "NONVR";
            }
            try {
                this.vrConfig.store(Files.newOutputStream(this.vrConfigPath, new OpenOption[0]), "This file stores if VR should be enabled.");
            }
            catch (IOException e) {
                this.showError = true;
            }
            button.method_25355((class_2561)class_2561.method_43471((String)(this.getIcon() + newMode)));
        });
        this.method_37063((class_364)this.vrModeButton);
    }

    private String getIcon() {
        boolean bl = this.showRestart = Boolean.parseBoolean(this.vrConfig.getProperty("vrStatus")) != VRState.isVR;
        return this.showError ? "\u00a7c\u26a0\u00a7r " : (this.showRestart ? "\u00a76\u24d8\u00a7r " : "");
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V", shift=At.Shift.BEFORE, ordinal=0)}, method={"render"})
    public void renderText(class_4587 poseStack, int i, int j, float f, CallbackInfo ci) {
        int l = this.vrModeButton.field_22761 - 23;
        TitleScreenMixin.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)"Vivecraft", (int)(this.field_22789 / 2 + 106), (int)l, (int)0xFFFFFF);
        TitleScreenMixin.method_27535((class_4587)poseStack, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"vivecraft.messages.mode"), (int)(this.field_22789 / 2 + 106), (int)(l + 10), (int)0xFFFFFF);
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    public void renderWarning(class_4587 poseStack, int i, int j, float f, CallbackInfo ci) {
        if (this.vrModeButton.method_25405((double)i, (double)j)) {
            this.method_25417(poseStack, this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"vivecraft.options.VR_MODE.tooltip"), Math.max(this.field_22789 / 2 - 43, 170)), i, j);
        }
        int warningHeight = this.firstButton.field_22761 - 10;
        class_5250 warning = null;
        if (this.showError) {
            warning = class_2561.method_43471((String)"vivecraft.messages.configWriteError");
        } else if (this.showRestart) {
            warning = class_2561.method_43471((String)"vivecraft.messages.configChangeRestart");
            warningHeight = this.field_22790 / 2;
        }
        if (warning != null) {
            int length = 0;
            List splitString = this.field_22793.method_1728(class_5348.method_29430((String)warning.getString()), 360);
            for (class_5481 string : splitString) {
                length = Math.max(length, this.field_22793.method_30880(string));
            }
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.0, 500.0);
            int n = this.field_22789 / 2 - length / 2 - 4;
            int n2 = this.field_22789 / 2 + length / 2 + 4;
            Objects.requireNonNull(this.field_22793);
            class_332.method_25294((class_4587)poseStack, (int)n, (int)(warningHeight - 4), (int)n2, (int)(warningHeight + (9 + 3) * splitString.size()), (int)-536870912);
            for (int line = 0; line < splitString.size(); ++line) {
                class_5481 class_54812 = (class_5481)splitString.get(line);
                int n3 = this.field_22789 / 2;
                Objects.requireNonNull(this.field_22793);
                TitleScreenMixin.method_35719((class_4587)poseStack, (class_327)this.field_22793, (class_5481)class_54812, (int)n3, (int)(warningHeight + (9 + 2) * line), (int)0xFFFFFF);
            }
            poseStack.method_22909();
        }
    }
}

