/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_759;
import net.minecraft.class_809;
import net.minecraft.class_898;
import net.minecraft.class_918;
import org.apache.commons.lang3.tuple.Triple;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.ClientDataHolder;
import org.vivecraft.extensions.EntityRenderDispatcherVRExtension;
import org.vivecraft.extensions.GameRendererExtension;
import org.vivecraft.extensions.ItemInHandRendererExtension;
import org.vivecraft.gameplay.trackers.BowTracker;
import org.vivecraft.gameplay.trackers.TelescopeTracker;
import org.vivecraft.render.RenderPass;
import org.vivecraft.render.VRArmRenderer;
import org.vivecraft.render.VRFirstPersonArmSwing;
import org.vivecraft.render.VivecraftItemRendering;

@Mixin(value={class_759.class}, priority=999)
public abstract class ItemInHandRendererVRMixin
implements ItemInHandRendererExtension {
    @Unique
    private float xdist = 0.0f;
    @Unique
    private VRFirstPersonArmSwing swingType = VRFirstPersonArmSwing.Attack;
    @Final
    @Shadow
    private class_310 field_4050;
    ClientDataHolder dh = ClientDataHolder.getInstance();
    @Final
    @Shadow
    private class_898 field_4046;
    @Final
    @Shadow
    private class_918 field_4044;
    @Shadow
    private float field_4053;
    @Shadow
    private float field_4043;
    @Shadow
    private float field_4051;
    @Shadow
    private float field_4052;

    @Override
    public Triple<Float, class_2680, class_2338> getNearOpaqueBlock(class_243 in, double dist) {
        if (this.field_4050.field_1687 == null) {
            return null;
        }
        class_238 aabb = new class_238(in.method_1023(dist, dist, dist), in.method_1031(dist, dist, dist));
        Stream<class_2338> stream = class_2338.method_29715((class_238)aabb).filter(bp -> this.field_4050.field_1687.method_8320(bp).method_26230((class_1922)this.field_4050.field_1687, bp));
        Optional<class_2338> optional = stream.findFirst();
        return optional.isPresent() ? Triple.of((Object)Float.valueOf(1.0f), (Object)this.field_4050.field_1687.method_8320(optional.get()), (Object)optional.get()) : null;
    }

    @Inject(at={@At(value="HEAD")}, method={"renderPlayerArm"}, cancellable=true)
    public void overrideArm(class_4587 poseStack, class_4597 multiBufferSource, int i, float f, float g, class_1306 humanoidArm, CallbackInfo ci) {
        this.vrPlayerArm(poseStack, multiBufferSource, i, f, g, humanoidArm);
        ci.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"renderArmWithItem"}, cancellable=true)
    public void overrideArmItem(class_742 abstractClientPlayer, float f, float g, class_1268 interactionHand, float h, class_1799 itemStack, float i, class_4587 poseStack, class_4597 multiBufferSource, int j, CallbackInfo ci) {
        this.vrRenderArmWithItem(abstractClientPlayer, f, g, interactionHand, h, itemStack, i, poseStack, multiBufferSource, j);
        ci.cancel();
    }

    @Override
    public boolean isInsideOpaqueBlock(class_243 in) {
        if (this.field_4050.field_1687 == null) {
            return false;
        }
        class_2338 blockpos = new class_2338(in);
        return this.field_4050.field_1687.method_8320(blockpos).method_26216((class_1922)this.field_4050.field_1687, blockpos);
    }

    public void vrRenderArmWithItem(class_742 pPlayer, float pPartialTicks, float pPitch, class_1268 pHand, float pSwingProgress, class_1799 pStack, float pEquippedProgress, class_4587 pMatrixStack, class_4597 pBuffer, int pCombinedLight) {
        boolean mainHand = pHand == class_1268.field_5808;
        class_1306 humanoidarm = mainHand ? pPlayer.method_6068() : pPlayer.method_6068().method_5928();
        pEquippedProgress = this.getEquipProgress(pHand, pPartialTicks);
        pMatrixStack.method_22903();
        boolean renderArm = true;
        if (this.dh.currentPass == RenderPass.THIRD && !this.dh.vrSettings.mixedRealityRenderHands) {
            renderArm = false;
        }
        if (this.dh.currentPass == RenderPass.CAMERA) {
            renderArm = false;
        }
        if (BowTracker.isBow(pStack) && this.dh.bowTracker.isActive((class_746)pPlayer)) {
            renderArm = false;
        }
        if (TelescopeTracker.isTelescope(pStack) && (pHand == class_1268.field_5810 && this.dh.currentPass == RenderPass.SCOPEL || pHand == class_1268.field_5808 && this.dh.currentPass == RenderPass.SCOPER)) {
            renderArm = false;
        }
        if (renderArm && !pPlayer.method_5767()) {
            this.method_3219(pMatrixStack, pBuffer, pCombinedLight, pEquippedProgress, pSwingProgress, humanoidarm);
        }
        if (!pStack.method_7960()) {
            class_809.class_811 transformType;
            pMatrixStack.method_22903();
            if (pPlayer.field_6266 == pHand) {
                this.transformFirstPersonVR(pMatrixStack, humanoidarm, pSwingProgress);
            }
            VivecraftItemRendering.VivecraftItemTransformType rendertype = VivecraftItemRendering.getTransformType(pStack, pPlayer, this.field_4044);
            boolean useLeftHandModelinLeftHand = false;
            if (this.dh.vrSettings.thirdPersonItems) {
                useLeftHandModelinLeftHand = true;
                VivecraftItemRendering.applyThirdPersonItemTransforms(pMatrixStack, rendertype, mainHand, pPlayer, pEquippedProgress, pPartialTicks, pStack, pHand);
                transformType = mainHand ? class_809.class_811.field_4320 : (useLeftHandModelinLeftHand ? class_809.class_811.field_4323 : class_809.class_811.field_4320);
            } else {
                VivecraftItemRendering.applyFirstPersonItemTransforms(pMatrixStack, rendertype, mainHand, pPlayer, pEquippedProgress, pPartialTicks, pStack, pHand);
                transformType = mainHand ? class_809.class_811.field_4322 : (useLeftHandModelinLeftHand ? class_809.class_811.field_4321 : class_809.class_811.field_4322);
            }
            ClientDataHolder.isfphand = true;
            if (rendertype == VivecraftItemRendering.VivecraftItemTransformType.Map) {
                RenderSystem.disableCull();
                this.method_3223(pMatrixStack, pBuffer, pCombinedLight, pStack);
            } else if (rendertype == VivecraftItemRendering.VivecraftItemTransformType.Telescope) {
                if (this.dh.currentPass != RenderPass.SCOPEL && this.dh.currentPass != RenderPass.SCOPER) {
                    pMatrixStack.method_22903();
                    pMatrixStack.method_22905(0.625f, 0.625f, 0.625f);
                    pMatrixStack.method_22904(mainHand ? -0.53 : -0.47, -0.5, -0.6);
                    this.field_4050.method_1541().method_3350().method_3367(pMatrixStack.method_23760(), pBuffer.getBuffer(class_4722.method_24073()), (class_2680)null, this.field_4050.method_1554().method_4742(TelescopeTracker.scopeModel), 0.5f, 0.5f, 1.0f, pCombinedLight, class_4608.field_21444);
                    pMatrixStack.method_22909();
                }
                pMatrixStack.method_22903();
                pMatrixStack.method_22904(mainHand ? -0.01875 : 0.01875, 0.215, -0.0626);
                pMatrixStack.method_22907(class_1160.field_20703.method_23214(90.0f));
                pMatrixStack.method_22907(class_1160.field_20705.method_23214(180.0f));
                pMatrixStack.method_22907(class_1160.field_20707.method_23214(180.0f));
                ((GameRendererExtension)this.field_4050.field_1773).DrawScopeFB(pMatrixStack, pHand == class_1268.field_5808 ? 0 : 1);
                pMatrixStack.method_22909();
            } else {
                this.method_3233((class_1309)pPlayer, pStack, transformType, !mainHand && useLeftHandModelinLeftHand, pMatrixStack, pBuffer, pCombinedLight);
            }
            ClientDataHolder.isfphand = false;
            pMatrixStack.method_22909();
        }
        pMatrixStack.method_22909();
    }

    @Shadow
    public abstract void method_3233(class_1309 var1, class_1799 var2, class_809.class_811 var3, boolean var4, class_4587 var5, class_4597 var6, int var7);

    @Shadow
    protected abstract void method_3223(class_4587 var1, class_4597 var2, int var3, class_1799 var4);

    @Shadow
    protected abstract void method_3219(class_4587 var1, class_4597 var2, int var3, float var4, float var5, class_1306 var6);

    public float getEquipProgress(class_1268 hand, float partialTicks) {
        return hand == class_1268.field_5808 ? 1.0f - (this.field_4053 + (this.field_4043 - this.field_4053) * partialTicks) : 1.0f - (this.field_4051 + (this.field_4052 - this.field_4051) * partialTicks);
    }

    public void vrPlayerArm(class_4587 poseStack, class_4597 multiBufferSource, int i, float f, float g, class_1306 humanoidArm) {
        boolean flag = humanoidArm != class_1306.field_6182;
        float h = flag ? 1.0f : -1.0f;
        class_746 abstractclientplayer = this.field_4050.field_1724;
        RenderSystem.setShaderTexture((int)0, (class_2960)abstractclientplayer.method_3117());
        VRArmRenderer vrarmrenderer = ((EntityRenderDispatcherVRExtension)this.field_4046).getArmSkinMap().get(abstractclientplayer.method_3121());
        poseStack.method_22903();
        if (abstractclientplayer.field_6266 == class_1268.field_5808 && flag) {
            this.transformFirstPersonVR(poseStack, humanoidArm, g);
        }
        if (abstractclientplayer.field_6266 == class_1268.field_5810 && !flag) {
            this.transformFirstPersonVR(poseStack, humanoidArm, g);
        }
        poseStack.method_22905(0.4f, 0.4f, 0.4f);
        boolean slim = abstractclientplayer.method_3121().equals("slim");
        poseStack.method_22904((double)((slim ? -0.34375f : -0.375f) * h), 0.0, slim ? 0.78125 : 0.75);
        poseStack.method_22907(class_1160.field_20703.method_23214(-90.0f));
        poseStack.method_22907(class_1160.field_20705.method_23214(180.0f));
        if (flag) {
            vrarmrenderer.method_4220(poseStack, multiBufferSource, i, (class_742)abstractclientplayer);
        } else {
            vrarmrenderer.method_4221(poseStack, multiBufferSource, i, (class_742)abstractclientplayer);
        }
        poseStack.method_22909();
    }

    @Override
    public void setXdist(float v) {
        this.xdist = v;
    }

    @Override
    public void setSwingType(VRFirstPersonArmSwing interact) {
        this.swingType = interact;
    }

    private void transformFirstPersonVR(class_4587 matrixStackIn, class_1306 hand, float swingProgress) {
        if (swingProgress != 0.0f) {
            switch (this.swingType) {
                case Attack: {
                    float f2 = class_3532.method_15374((float)((float)((double)(swingProgress * 3.0f) * Math.PI)));
                    if ((double)swingProgress > 0.5) {
                        f2 = class_3532.method_15374((float)((float)((double)swingProgress * Math.PI + Math.PI)));
                    }
                    matrixStackIn.method_22904(0.0, 0.0, (double)0.2f);
                    matrixStackIn.method_22907(class_1160.field_20703.method_23214(f2 * 30.0f));
                    matrixStackIn.method_22904(0.0, 0.0, (double)-0.2f);
                    break;
                }
                case Interact: {
                    float f1 = class_3532.method_15374((float)((float)((double)(swingProgress * 3.0f) * Math.PI)));
                    if ((double)swingProgress > 0.5) {
                        f1 = class_3532.method_15374((float)((float)((double)swingProgress * Math.PI + Math.PI)));
                    }
                    matrixStackIn.method_22907(class_1160.field_20707.method_23214((float)(hand == class_1306.field_6183 ? -1 : 1) * f1 * 45.0f));
                    break;
                }
                case Use: {
                    float f = class_3532.method_15374((float)((float)((double)(swingProgress * 2.0f) * Math.PI)));
                    if ((double)swingProgress > 0.25) {
                        f = class_3532.method_15374((float)((float)((double)(swingProgress / 2.0f) * Math.PI + Math.PI)));
                    }
                    matrixStackIn.method_22904(0.0, 0.0, (double)(-(1.0f + f) * 0.1f));
                }
            }
        }
    }
}

