/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.modCompatMixin.irisMixin;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.pipeline.PipelineManager;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.ClientDataHolder;
import org.vivecraft.extensions.iris.PipelineManagerExtension;
import org.vivecraft.render.RenderPass;

@Pseudo
@Mixin(value={PipelineManager.class})
public class IrisPipelineManagerVRMixin
implements PipelineManagerExtension {
    @Shadow(remap=false)
    private WorldRenderingPipeline pipeline;
    @Shadow(remap=false)
    @Final
    private Function<DimensionId, WorldRenderingPipeline> pipelineFactory;
    private ShadowRenderTargets shadowRenderTargets;
    private final Map<RenderPass, WorldRenderingPipeline> vrPipelines = new HashMap<RenderPass, WorldRenderingPipeline>();

    @Shadow(remap=false)
    private void resetTextureState() {
    }

    @Override
    public ShadowRenderTargets getShadowRenderTargets() {
        return this.shadowRenderTargets;
    }

    @Override
    public void setShadowRenderTargets(ShadowRenderTargets targets) {
        this.shadowRenderTargets = targets;
    }

    @Inject(method={"preparePipeline"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")}, remap=false)
    private void generateVRPipelines(DimensionId newDimension, CallbackInfoReturnable<WorldRenderingPipeline> cir) {
        class_276 current = class_310.method_1551().field_1689;
        this.shadowRenderTargets = null;
        for (RenderPass renderPass : RenderPass.values()) {
            Iris.logger.info("Creating VR pipeline for dimension {}, RenderPass {}", new Object[]{newDimension, renderPass});
            switch (renderPass) {
                case LEFT: 
                case RIGHT: {
                    class_310.method_1551().field_1689 = ClientDataHolder.getInstance().vrRenderer.framebufferVrRender;
                    break;
                }
                case CENTER: {
                    class_310.method_1551().field_1689 = ClientDataHolder.getInstance().vrRenderer.framebufferUndistorted;
                    break;
                }
                case THIRD: {
                    class_310.method_1551().field_1689 = ClientDataHolder.getInstance().vrRenderer.framebufferMR;
                    break;
                }
                case SCOPEL: {
                    class_310.method_1551().field_1689 = ClientDataHolder.getInstance().vrRenderer.telescopeFramebufferL;
                    break;
                }
                case SCOPER: {
                    class_310.method_1551().field_1689 = ClientDataHolder.getInstance().vrRenderer.telescopeFramebufferR;
                    break;
                }
                case CAMERA: {
                    class_310.method_1551().field_1689 = ClientDataHolder.getInstance().vrRenderer.cameraRenderFramebuffer;
                    break;
                }
                default: {
                    class_310.method_1551().field_1689 = null;
                }
            }
            if (class_310.method_1551().field_1689 == null) {
                Iris.logger.info("skipped VR pipeline for dimension {}, RenderPass {}, not used", new Object[]{newDimension, renderPass});
                continue;
            }
            this.pipeline = this.pipelineFactory.apply(newDimension);
            this.vrPipelines.put(renderPass, this.pipeline);
        }
        class_310.method_1551().field_1689 = current;
        this.pipeline = ClientDataHolder.getInstance().currentPass != null ? this.vrPipelines.get((Object)ClientDataHolder.getInstance().currentPass) : this.vrPipelines.get((Object)RenderPass.LEFT);
    }

    @Inject(method={"preparePipeline"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;")}, remap=false, cancellable=true)
    private void returnCurrentVRPipeline(DimensionId newDimension, CallbackInfoReturnable<WorldRenderingPipeline> cir) {
        this.pipeline = this.vrPipelines.get((Object)ClientDataHolder.getInstance().currentPass);
        cir.setReturnValue((Object)this.pipeline);
    }

    @Inject(method={"destroyPipeline"}, at={@At(value="INVOKE", target="Ljava/util/Map;clear()V")}, remap=false)
    private void destroyVRPipelines(CallbackInfo ci) {
        this.vrPipelines.forEach((renderPass, pipeline) -> {
            Iris.logger.info("Destroying VR pipeline {}", new Object[]{renderPass});
            this.resetTextureState();
            pipeline.destroy();
        });
        this.shadowRenderTargets = null;
        this.vrPipelines.clear();
    }

    @Override
    public WorldRenderingPipeline getVRPipeline(RenderPass pass) {
        return this.vrPipelines.get((Object)pass);
    }
}

