/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL43C;

public class ShaderHelper {
    private static int createShader(String shaderGLSL, int shaderType) throws Exception {
        int i = 0;
        try {
            i = GlStateManager.glCreateShader((int)shaderType);
            if (i == 0) {
                return 0;
            }
            GlStateManager.glShaderSource((int)i, List.of(shaderGLSL));
            GlStateManager.glCompileShader((int)i);
            String log = GL20C.glGetShaderInfoLog((int)i);
            if (!log.isEmpty()) {
                throw new RuntimeException("Error creating shader: " + log);
            }
            return i;
        }
        catch (Exception exception) {
            GlStateManager.glDeleteShader((int)i);
            throw exception;
        }
    }

    public static int checkGLError(String par1Str) {
        int i = GL11.glGetError();
        if (i != 0) {
            String s = "";
            System.out.println("########## GL ERROR ##########");
            System.out.println("@ " + par1Str);
            System.out.println(i + ": " + s);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int initShaders(String vertexShaderGLSL, String fragmentShaderGLSL, boolean doAttribs) {
        int k;
        int j;
        int i;
        block9: {
            int b0;
            block10: {
                i = 0;
                j = 0;
                k = 0;
                try {
                    i = ShaderHelper.createShader(vertexShaderGLSL, 35633);
                    j = ShaderHelper.createShader(fragmentShaderGLSL, 35632);
                    break block9;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    b0 = 0;
                    return b0;
                }
                finally {
                    if (i != 0 && j != 0) break block10;
                    return 0;
                }
            }
            return b0;
        }
        k = GlStateManager.glCreateProgram();
        if (k == 0) {
            return 0;
        }
        GlStateManager.glAttachShader((int)k, (int)i);
        GlStateManager.glAttachShader((int)k, (int)j);
        if (doAttribs) {
            GlStateManager._glBindAttribLocation((int)k, (int)0, (CharSequence)"in_Position");
            ShaderHelper.checkGLError("@2");
            GlStateManager._glBindAttribLocation((int)k, (int)1, (CharSequence)"in_Color");
            ShaderHelper.checkGLError("@2a");
            GlStateManager._glBindAttribLocation((int)k, (int)2, (CharSequence)"in_TextureCoord");
            ShaderHelper.checkGLError("@3");
        }
        GL43C.glLinkProgram((int)k);
        ShaderHelper.checkGLError("Link");
        String log = GL20C.glGetShaderInfoLog((int)i);
        if (!log.isEmpty()) {
            System.out.println("Shader compilation log: " + log);
            return 0;
        }
        String log2 = GL20C.glGetShaderInfoLog((int)j);
        if (!log2.isEmpty()) {
            System.out.println("Shader compilation log: " + log2);
            return 0;
        }
        return k;
    }
}

