/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.tweaker;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.util.HashMap;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class LoaderUtils {
    public static URL ZipFileUrl;
    public static File vivecraftFile;
    private static ZipFile ZipFile;

    public static void init() {
        try {
            ZipFileUrl = LoaderUtils.getVivecraftZipLocation().toURL();
            vivecraftFile = LoaderUtils.toFile(ZipFileUrl.toURI());
            ZipFile = new ZipFile(vivecraftFile);
        }
        catch (Exception e) {
            System.out.print("Error getting Vivecraft library: " + e.getLocalizedMessage());
        }
    }

    public static URI getVivecraftZipLocation() throws URISyntaxException {
        if (ZipFileUrl != null) {
            return ZipFileUrl.toURI();
        }
        ZipFileUrl = LoaderUtils.class.getProtectionDomain().getCodeSource().getLocation();
        if (ZipFileUrl == null) {
            throw new RuntimeException("Could not find Vivecraft zip");
        }
        return ZipFileUrl.toURI();
    }

    public static ZipFile getVivecraftZip() throws ZipException, URISyntaxException, IOException {
        if (vivecraftFile == null) {
            LoaderUtils.init();
        }
        return new ZipFile(vivecraftFile);
    }

    public static File toFile(URI uri) {
        if (!"union".equals(uri.getScheme())) {
            return new File(uri);
        }
        try {
            String s = uri.getPath();
            if (s.contains("#")) {
                s = s.substring(0, s.lastIndexOf("#"));
            }
            File file1 = new File(s);
            ZipFileUrl = file1.toURI().toURL();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("create", "true");
            FileSystems.newFileSystem(URI.create("jar:" + ZipFileUrl + "!/"), map);
            return file1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

