/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.potatoCannon;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.potatoCannon.BuiltinPotatoProjectileTypes;
import com.simibubi.create.content.equipment.potatoCannon.PotatoCannonProjectileType;
import com.simibubi.create.content.equipment.potatoCannon.PotatoProjectileRenderMode;
import com.simibubi.create.content.equipment.potatoCannon.PotatoProjectileTypeManager;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.particle.AirParticleData;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.entity.ExtraSpawnDataEntity;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1282;
import net.minecraft.class_1284;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;

public class PotatoProjectileEntity
extends class_1668
implements ExtraSpawnDataEntity {
    protected PotatoCannonProjectileType type;
    protected class_1799 stack = class_1799.field_8037;
    protected class_1297 stuckEntity;
    protected class_243 stuckOffset;
    protected PotatoProjectileRenderMode stuckRenderer;
    protected double stuckFallSpeed;
    protected float additionalDamageMult = 1.0f;
    protected float additionalKnockback = 0.0f;
    protected float recoveryChance = 0.0f;

    public PotatoProjectileEntity(class_1299<? extends class_1668> type, class_1937 world) {
        super(type, world);
    }

    public class_1799 getItem() {
        return this.stack;
    }

    public void setItem(class_1799 stack) {
        this.stack = stack;
    }

    public PotatoCannonProjectileType getProjectileType() {
        if (this.type == null) {
            this.type = PotatoProjectileTypeManager.getTypeForStack(this.stack).orElse(BuiltinPotatoProjectileTypes.FALLBACK);
        }
        return this.type;
    }

    public void setEnchantmentEffectsFromCannon(class_1799 cannon) {
        int power = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)cannon);
        int punch = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)cannon);
        int flame = class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)cannon);
        int recovery = class_1890.method_8225((class_1887)((class_1887)AllEnchantments.POTATO_RECOVERY.get()), (class_1799)cannon);
        if (power > 0) {
            this.additionalDamageMult = 1.0f + (float)power * 0.2f;
        }
        if (punch > 0) {
            this.additionalKnockback = (float)punch * 0.5f;
        }
        if (flame > 0) {
            this.method_5639(100);
        }
        if (recovery > 0) {
            this.recoveryChance = 0.125f + (float)recovery * 0.125f;
        }
    }

    public void method_5749(class_2487 nbt) {
        this.stack = class_1799.method_7915((class_2487)nbt.method_10562("Item"));
        this.additionalDamageMult = nbt.method_10583("AdditionalDamage");
        this.additionalKnockback = nbt.method_10583("AdditionalKnockback");
        this.recoveryChance = nbt.method_10583("Recovery");
        super.method_5749(nbt);
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10566("Item", NBTSerializer.serializeNBT((Object)this.stack));
        nbt.method_10548("AdditionalDamage", this.additionalDamageMult);
        nbt.method_10548("AdditionalKnockback", this.additionalKnockback);
        nbt.method_10548("Recovery", this.recoveryChance);
        super.method_5652(nbt);
    }

    public class_1297 getStuckEntity() {
        if (this.stuckEntity == null) {
            return null;
        }
        if (!this.stuckEntity.method_5805()) {
            return null;
        }
        return this.stuckEntity;
    }

    public void setStuckEntity(class_1297 stuckEntity) {
        this.stuckEntity = stuckEntity;
        this.stuckOffset = this.method_19538().method_1020(stuckEntity.method_19538());
        this.stuckRenderer = new PotatoProjectileRenderMode.StuckToEntity(this.stuckOffset);
        this.stuckFallSpeed = 0.0;
        this.method_18799(class_243.field_1353);
    }

    public PotatoProjectileRenderMode getRenderMode() {
        if (this.getStuckEntity() != null) {
            return this.stuckRenderer;
        }
        return this.getProjectileType().getRenderMode();
    }

    public void method_5773() {
        PotatoCannonProjectileType projectileType = this.getProjectileType();
        class_1297 stuckEntity = this.getStuckEntity();
        if (stuckEntity != null) {
            if (this.method_23318() < stuckEntity.method_23318() - 0.1) {
                this.pop(this.method_19538());
                this.method_5768();
            } else {
                this.stuckFallSpeed += 0.007 * (double)projectileType.getGravityMultiplier();
                this.stuckOffset = this.stuckOffset.method_1031(0.0, -this.stuckFallSpeed, 0.0);
                class_243 pos = stuckEntity.method_19538().method_1019(this.stuckOffset);
                this.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
            }
        } else {
            this.method_18799(this.method_18798().method_1031(0.0, -0.05 * (double)projectileType.getGravityMultiplier(), 0.0).method_1021((double)projectileType.getDrag()));
        }
        super.method_5773();
    }

    protected float method_7466() {
        return 1.0f;
    }

    protected class_2394 method_7467() {
        return new AirParticleData(1.0f, 10.0f);
    }

    protected boolean method_7468() {
        return false;
    }

    protected void method_7454(class_3966 ray) {
        class_243 appliedMotion;
        boolean onServer;
        super.method_7454(ray);
        if (this.getStuckEntity() != null) {
            return;
        }
        class_243 hit = ray.method_17784();
        class_1297 target = ray.method_17782();
        PotatoCannonProjectileType projectileType = this.getProjectileType();
        float damage = (float)projectileType.getDamage() * this.additionalDamageMult;
        float knockback = projectileType.getKnockback() + this.additionalKnockback;
        class_1297 owner = this.method_24921();
        if (!target.method_5805()) {
            return;
        }
        if (owner instanceof class_1309) {
            ((class_1309)owner).method_6114(target);
        }
        if (target instanceof PotatoProjectileEntity) {
            PotatoProjectileEntity ppe = (PotatoProjectileEntity)target;
            if (this.field_6012 < 10 && target.field_6012 < 10) {
                return;
            }
            if (ppe.getProjectileType() != this.getProjectileType()) {
                class_1297 class_12972;
                class_1657 p;
                if (owner instanceof class_1657) {
                    p = (class_1657)owner;
                    AllAdvancements.POTATO_CANNON_COLLIDE.awardTo(p);
                }
                if ((class_12972 = ppe.method_24921()) instanceof class_1657) {
                    p = (class_1657)class_12972;
                    AllAdvancements.POTATO_CANNON_COLLIDE.awardTo(p);
                }
            }
        }
        this.pop(hit);
        if (target instanceof class_1528 && ((class_1528)target).method_6872()) {
            return;
        }
        if (projectileType.preEntityHit(ray)) {
            return;
        }
        boolean targetIsEnderman = target.method_5864() == class_1299.field_6091;
        int k = target.method_20802();
        if (this.method_5809() && !targetIsEnderman) {
            target.method_5639(5);
        }
        boolean bl = onServer = !this.field_6002.field_9236;
        if (onServer && !target.method_5643(this.causePotatoDamage(), damage)) {
            target.method_20803(k);
            this.method_5768();
            return;
        }
        if (targetIsEnderman) {
            return;
        }
        if (!projectileType.onEntityHit(ray) && onServer && this.field_5974.method_43058() <= (double)this.recoveryChance) {
            this.recoverItem();
        }
        if (!(target instanceof class_1309)) {
            PotatoProjectileEntity.playHitSound(this.field_6002, this.method_19538());
            this.method_5768();
            return;
        }
        class_1309 livingentity = (class_1309)target;
        if (this.type.getReloadTicks() < 10) {
            livingentity.field_6008 = this.type.getReloadTicks() + 10;
        }
        if (onServer && knockback > 0.0f && (appliedMotion = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029().method_1021((double)knockback * 0.6)).method_1027() > 0.0) {
            livingentity.method_5762(appliedMotion.field_1352, 0.1, appliedMotion.field_1350);
        }
        if (onServer && owner instanceof class_1309) {
            class_1890.method_8210((class_1309)livingentity, (class_1297)owner);
            class_1890.method_8213((class_1309)((class_1309)owner), (class_1297)livingentity);
        }
        if (livingentity != owner && livingentity instanceof class_1657 && owner instanceof class_3222 && !this.method_5701()) {
            ((class_3222)owner).field_13987.method_14364((class_2596)new class_2668(class_2668.field_25651, 0.0f));
        }
        if (onServer && owner instanceof class_3222) {
            class_3222 serverplayerentity = (class_3222)owner;
            if (!target.method_5805() && target.method_5864().method_5891() == class_1311.field_6302 || target instanceof class_1657 && target != owner) {
                AllAdvancements.POTATO_CANNON.awardTo((class_1657)serverplayerentity);
            }
        }
        if (this.type.isSticky() && target.method_5805()) {
            this.setStuckEntity(target);
        } else {
            this.method_5768();
        }
    }

    private void recoverItem() {
        if (!this.stack.method_7960()) {
            this.method_5775(ItemHandlerHelper.copyStackWithSize((class_1799)this.stack, (int)1));
        }
    }

    public static void playHitSound(class_1937 world, class_243 location) {
        AllSoundEvents.POTATO_HIT.playOnServer(world, (class_2382)new class_2338(location));
    }

    public static void playLaunchSound(class_1937 world, class_243 location, float pitch) {
        AllSoundEvents.FWOOMP.playAt(world, location, 1.0f, pitch, true);
    }

    protected void method_24920(class_3965 ray) {
        class_243 hit = ray.method_17784();
        this.pop(hit);
        if (!this.getProjectileType().onBlockHit((class_1936)this.field_6002, ray) && !this.field_6002.field_9236 && this.field_5974.method_43058() <= (double)this.recoveryChance) {
            this.recoverItem();
        }
        super.method_24920(ray);
        this.method_5768();
    }

    public boolean method_5643(class_1282 source, float amt) {
        if (source == class_1282.field_5867 || source == class_1282.field_5854) {
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        this.pop(this.method_19538());
        this.method_5768();
        return true;
    }

    private void pop(class_243 hit) {
        if (!this.stack.method_7960()) {
            for (int i = 0; i < 7; ++i) {
                class_243 m = VecHelper.offsetRandomly(class_243.field_1353, this.field_5974, 0.25f);
                this.field_6002.method_8406((class_2394)new class_2392(class_2398.field_11218, this.stack), hit.field_1352, hit.field_1351, hit.field_1350, m.field_1352, m.field_1351, m.field_1350);
            }
        }
        if (!this.field_6002.field_9236) {
            PotatoProjectileEntity.playHitSound(this.field_6002, this.method_19538());
        }
    }

    private class_1282 causePotatoDamage() {
        return new PotatoDamageSource((class_1297)this, this.method_24921()).method_5517();
    }

    public static FabricEntityTypeBuilder<?> build(FabricEntityTypeBuilder<?> builder) {
        return builder.dimensions(class_4048.method_18385((float)0.25f, (float)0.25f));
    }

    public class_2596<?> method_18002() {
        return ExtraSpawnDataEntity.createExtraDataSpawnPacket((class_1297)this);
    }

    public void writeSpawnData(class_2540 buffer) {
        class_2487 compound = new class_2487();
        this.method_5652(compound);
        buffer.method_10794(compound);
    }

    public void readSpawnData(class_2540 additionalData) {
        this.method_5749(additionalData.method_10798());
    }

    public static class PotatoDamageSource
    extends class_1284 {
        public PotatoDamageSource(class_1297 source, @Nullable class_1297 trueSource) {
            super("create.potato_cannon", source, trueSource);
        }
    }
}

