/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.fan;

import com.simibubi.create.content.kinetics.fan.AirFlowParticleData;
import com.simibubi.create.content.kinetics.fan.FanProcessing;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nonnull;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_708;
import net.minecraft.class_761;

public class AirFlowParticle
extends class_708 {
    private final IAirCurrentSource source;

    protected AirFlowParticle(class_638 world, IAirCurrentSource source, double x, double y, double z, class_4002 sprite) {
        super(world, x, y, z, sprite, world.field_9229.method_43057() * 0.5f);
        this.source = source;
        this.field_17867 *= 0.75f;
        this.field_3847 = 40;
        this.field_3862 = false;
        this.selectSprite(7);
        class_243 offset = VecHelper.offsetRandomly(class_243.field_1353, world.field_9229, 0.25f);
        this.method_3063(x + offset.field_1352, y + offset.field_1351, z + offset.field_1350);
        this.field_3858 = x;
        this.field_3838 = y;
        this.field_3856 = z;
        this.method_3083(0.25f);
    }

    @Nonnull
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public void method_3070() {
        if (this.source == null || this.source.isSourceRemoved()) {
            this.dissipate();
            return;
        }
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        } else {
            double distance;
            if (this.source.getAirCurrent() == null || !this.source.getAirCurrent().bounds.method_1014(0.25).method_1008(this.field_3874, this.field_3854, this.field_3871)) {
                this.dissipate();
                return;
            }
            class_243 directionVec = class_243.method_24954((class_2382)this.source.getAirCurrent().direction.method_10163());
            class_243 motion = directionVec.method_1021(0.125);
            if (!this.source.getAirCurrent().pushing) {
                motion = motion.method_1021(-1.0);
            }
            if ((distance = new class_243(this.field_3874, this.field_3854, this.field_3871).method_1020(VecHelper.getCenterOf((class_2382)this.source.getAirCurrentPos())).method_18806(directionVec).method_1033() - 0.5) > (double)(this.source.getAirCurrent().maxDistance + 1.0f) || distance < -0.25) {
                this.dissipate();
                return;
            }
            motion = motion.method_1021((double)this.source.getAirCurrent().maxDistance - (distance - 1.0)).method_1021(0.5);
            this.selectSprite((int)class_3532.method_15350((double)(distance / (double)this.source.getAirCurrent().maxDistance * 8.0 + (double)this.field_3851.field_9229.method_43048(4)), (double)0.0, (double)7.0));
            this.morphType(distance);
            this.field_3852 = motion.field_1352;
            this.field_3869 = motion.field_1351;
            this.field_3850 = motion.field_1350;
            if (this.field_3845) {
                this.field_3852 *= 0.7;
                this.field_3850 *= 0.7;
            }
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        }
    }

    public void morphType(double distance) {
        if (this.source.getAirCurrent() == null) {
            return;
        }
        FanProcessing.Type type = this.source.getAirCurrent().getSegmentAt((float)distance);
        if (type == FanProcessing.Type.SPLASHING) {
            this.method_3093(Color.mixColors(0x4499FF, 0x2277FF, this.field_3851.field_9229.method_43057()));
            this.method_3083(1.0f);
            this.selectSprite(this.field_3851.field_9229.method_43048(3));
            if (this.field_3851.field_9229.method_43057() < 0.03125f) {
                this.field_3851.method_8406((class_2394)class_2398.field_11247, this.field_3874, this.field_3854, this.field_3871, this.field_3852 * 0.125, this.field_3869 * 0.125, this.field_3850 * 0.125);
            }
            if (this.field_3851.field_9229.method_43057() < 0.03125f) {
                this.field_3851.method_8406((class_2394)class_2398.field_11241, this.field_3874, this.field_3854, this.field_3871, this.field_3852 * 0.125, this.field_3869 * 0.125, this.field_3850 * 0.125);
            }
        }
        if (type == FanProcessing.Type.SMOKING) {
            this.method_3093(Color.mixColors(0, 0x555555, this.field_3851.field_9229.method_43057()));
            this.method_3083(1.0f);
            this.selectSprite(this.field_3851.field_9229.method_43048(3));
            if (this.field_3851.field_9229.method_43057() < 0.03125f) {
                this.field_3851.method_8406((class_2394)class_2398.field_11251, this.field_3874, this.field_3854, this.field_3871, this.field_3852 * 0.125, this.field_3869 * 0.125, this.field_3850 * 0.125);
            }
            if (this.field_3851.field_9229.method_43057() < 0.03125f) {
                this.field_3851.method_8406((class_2394)class_2398.field_11237, this.field_3874, this.field_3854, this.field_3871, this.field_3852 * 0.125, this.field_3869 * 0.125, this.field_3850 * 0.125);
            }
        }
        if (type == FanProcessing.Type.HAUNTING) {
            this.method_3093(Color.mixColors(0, 1205608, this.field_3851.field_9229.method_43057()));
            this.method_3083(1.0f);
            this.selectSprite(this.field_3851.field_9229.method_43048(3));
            if (this.field_3851.field_9229.method_43057() < 0.0078125f) {
                this.field_3851.method_8406((class_2394)class_2398.field_22246, this.field_3874, this.field_3854, this.field_3871, this.field_3852 * 0.125, this.field_3869 * 0.125, this.field_3850 * 0.125);
            }
            if (this.field_3851.field_9229.method_43057() < 0.03125f) {
                this.field_3851.method_8406((class_2394)class_2398.field_11251, this.field_3874, this.field_3854, this.field_3871, this.field_3852 * 0.125, this.field_3869 * 0.125, this.field_3850 * 0.125);
            }
        }
        if (type == FanProcessing.Type.BLASTING) {
            this.method_3093(Color.mixColors(0xFF4400, 0xFF8855, this.field_3851.field_9229.method_43057()));
            this.method_3083(0.5f);
            this.selectSprite(this.field_3851.field_9229.method_43048(3));
            if (this.field_3851.field_9229.method_43057() < 0.03125f) {
                this.field_3851.method_8406((class_2394)class_2398.field_11240, this.field_3874, this.field_3854, this.field_3871, this.field_3852 * 0.25, this.field_3869 * 0.25, this.field_3850 * 0.25);
            }
            if (this.field_3851.field_9229.method_43057() < 0.0625f) {
                this.field_3851.method_8406((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10164.method_9564()), this.field_3874, this.field_3854, this.field_3871, this.field_3852 * 0.25, this.field_3869 * 0.25, this.field_3850 * 0.25);
            }
        }
        if (type == null) {
            this.method_3093(0xEEEEEE);
            this.method_3083(0.25f);
            this.method_3080(0.2f, 0.2f);
        }
    }

    private void dissipate() {
        this.method_3085();
    }

    public int method_3068(float partialTick) {
        class_2338 blockpos = new class_2338(this.field_3874, this.field_3854, this.field_3871);
        return this.field_3851.method_8477(blockpos) ? class_761.method_23794((class_1920)this.field_3851, (class_2338)blockpos) : 0;
    }

    private void selectSprite(int index) {
        this.method_18141(this.field_17866.method_18138(index, 8));
    }

    public static class Factory
    implements class_707<AirFlowParticleData> {
        private final class_4002 spriteSet;

        public Factory(class_4002 animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public class_703 createParticle(AirFlowParticleData data, class_638 worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            class_2586 be = worldIn.method_8321(new class_2338(data.posX, data.posY, data.posZ));
            if (!(be instanceof IAirCurrentSource)) {
                be = null;
            }
            return new AirFlowParticle(worldIn, (IAirCurrentSource)be, x, y, z, this.spriteSet);
        }
    }
}

