/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.bogey;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import java.util.Optional;
import net.minecraft.class_1920;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4587;

public final class BogeyInstance {
    private final BogeySizes.BogeySize size;
    private final BogeyStyle style;
    public final CarriageBogey bogey;
    public final BogeyRenderer renderer;
    public final Optional<BogeyRenderer.CommonRenderer> commonRenderer;

    public BogeyInstance(CarriageBogey bogey, BogeyStyle style, BogeySizes.BogeySize size, MaterialManager materialManager) {
        this.bogey = bogey;
        this.size = size;
        this.style = style;
        this.renderer = this.style.createRendererInstance(this.size);
        this.commonRenderer = this.style.getNewCommonRenderInstance();
        this.commonRenderer.ifPresent(bogeyRenderer -> bogeyRenderer.initialiseContraptionModelData(materialManager));
        this.renderer.initialiseContraptionModelData(materialManager);
    }

    public void beginFrame(float wheelAngle, class_4587 ms) {
        if (ms == null) {
            this.renderer.emptyTransforms();
            return;
        }
        this.commonRenderer.ifPresent(bogeyRenderer -> bogeyRenderer.render(this.bogey.bogeyData, wheelAngle, ms));
        this.renderer.render(this.bogey.bogeyData, wheelAngle, ms);
    }

    public void updateLight(class_1920 world, CarriageContraptionEntity entity) {
        class_2338 lightPos = new class_2338(this.getLightPos(entity));
        this.commonRenderer.ifPresent(bogeyRenderer -> bogeyRenderer.updateLight(world.method_8314(class_1944.field_9282, lightPos), world.method_8314(class_1944.field_9284, lightPos)));
        this.renderer.updateLight(world.method_8314(class_1944.field_9282, lightPos), world.method_8314(class_1944.field_9284, lightPos));
    }

    private class_243 getLightPos(CarriageContraptionEntity entity) {
        return this.bogey.getAnchorPosition() != null ? this.bogey.getAnchorPosition() : entity.method_31166(AnimationTickHolder.getPartialTicks());
    }

    @FunctionalInterface
    static interface BogeyInstanceFactory {
        public BogeyInstance create(CarriageBogey var1, BogeySizes.BogeySize var2, MaterialManager var3);
    }
}

