/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.bogey;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.Transform;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;

public abstract class BogeyRenderer {
    Map<String, ModelData[]> contraptionModelData = new HashMap<String, ModelData[]>();

    public Transform<?>[] getTransformsFromPartial(PartialModel model, class_4587 ms, boolean inInstancedContraption, int size) {
        return inInstancedContraption ? this.transformContraptionModelData(this.keyFromModel(model), ms) : this.createModelData(model, size);
    }

    public Transform<?>[] getTransformsFromBlockState(class_2680 state, class_4587 ms, boolean inContraption, int size) {
        return inContraption ? this.transformContraptionModelData(this.keyFromModel(state), ms) : this.createModelData(state, size);
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void render(class_2487 var1, float var2, class_4587 var3, int var4, class_4588 var5, boolean var6);

    @Environment(value=EnvType.CLIENT)
    public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms) {
        this.render(bogeyData, wheelAngle, ms, 0, null, true);
    }

    public abstract BogeySizes.BogeySize getSize();

    private Transform<?>[] transformContraptionModelData(String key, class_4587 ms) {
        ModelData[] modelData = this.contraptionModelData.get(key);
        Arrays.stream(modelData).forEach(modelDataElement -> modelDataElement.setTransform(ms));
        return modelData;
    }

    private Transform<?>[] createModelData(PartialModel model, int size) {
        class_2680 air = class_2246.field_10124.method_9564();
        SuperByteBuffer[] data = new SuperByteBuffer[]{CachedBufferer.partial(model, air)};
        return this.expandArrayToLength(data, size);
    }

    private Transform<?>[] createModelData(class_2680 state, int size) {
        SuperByteBuffer[] data = new SuperByteBuffer[]{CachedBufferer.block(state)};
        return this.expandArrayToLength(data, size);
    }

    private Transform<?>[] expandArrayToLength(SuperByteBuffer[] data, int size) {
        return (Transform[])Arrays.stream(Collections.nCopies(size, data).toArray()).flatMap(inner -> Arrays.stream((SuperByteBuffer[])inner)).toArray(SuperByteBuffer[]::new);
    }

    public Transform<?> getTransformFromPartial(PartialModel model, class_4587 ms, boolean inInstancedContraption) {
        class_2680 air = class_2246.field_10124.method_9564();
        return inInstancedContraption ? this.contraptionModelData.get(this.keyFromModel(model))[0].setTransform(ms) : CachedBufferer.partial(model, air);
    }

    public Transform<?> getTransformFromBlockState(class_2680 state, class_4587 ms, boolean inContraption) {
        return inContraption ? this.contraptionModelData.get(this.keyFromModel(state))[0].setTransform(ms) : CachedBufferer.block(state);
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void initialiseContraptionModelData(MaterialManager var1);

    public void createModelInstances(MaterialManager materialManager, PartialModel model, int count) {
        ModelData[] modelData = new ModelData[count];
        materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(model).createInstances((InstanceData[])modelData);
        this.contraptionModelData.put(this.keyFromModel(model), modelData);
    }

    public void createModelInstances(MaterialManager materialManager, class_2680 state, int count) {
        ModelData[] modelData = new ModelData[count];
        materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(state).createInstances((InstanceData[])modelData);
        this.contraptionModelData.put(this.keyFromModel(state), modelData);
    }

    public void createModelInstance(MaterialManager materialManager, class_2680 state) {
        this.createModelInstances(materialManager, state, 1);
    }

    public void createModelInstances(MaterialManager materialManager, PartialModel ... models) {
        for (PartialModel model : models) {
            this.createModelInstances(materialManager, model, 1);
        }
    }

    public static <B extends Transform<?>> void finalize(B b, class_4587 ms, int light, @Nullable class_4588 vb) {
        b.scale(0.9980469f);
        if (b instanceof SuperByteBuffer) {
            SuperByteBuffer byteBuf = (SuperByteBuffer)b;
            if (vb != null) {
                byteBuf.light(light).renderInto(ms, vb);
            }
        }
    }

    public void emptyTransforms() {
        for (ModelData[] data : this.contraptionModelData.values()) {
            for (ModelData model : data) {
                model.setEmptyTransform();
            }
        }
    }

    public void updateLight(int blockLight, int skyLight) {
        for (ModelData[] data : this.contraptionModelData.values()) {
            for (ModelData model : data) {
                model.setBlockLight(blockLight).setSkyLight(skyLight);
            }
        }
    }

    public void remove() {
        for (ModelData[] data : this.contraptionModelData.values()) {
            for (ModelData model : data) {
                model.delete();
            }
        }
        this.contraptionModelData.clear();
    }

    private String keyFromModel(PartialModel partialModel) {
        return partialModel.getLocation().toString();
    }

    private String keyFromModel(class_2680 state) {
        return state.toString();
    }

    public static abstract class CommonRenderer
    extends BogeyRenderer {
        @Override
        public BogeySizes.BogeySize getSize() {
            return null;
        }
    }
}

