/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.graph;

import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_5321;

public class TrackNodeLocation
extends class_2382 {
    public class_5321<class_1937> dimension;
    public int yOffsetPixels;

    public TrackNodeLocation(class_243 vec) {
        this(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public TrackNodeLocation(double x, double y, double z) {
        super((double)Math.round(x * 2.0), Math.floor(y) * 2.0, (double)Math.round(z * 2.0));
    }

    public TrackNodeLocation in(class_1937 level) {
        return this.in((class_5321<class_1937>)level.method_27983());
    }

    public TrackNodeLocation in(class_5321<class_1937> dimension) {
        this.dimension = dimension;
        return this;
    }

    private static TrackNodeLocation fromPackedPos(class_2338 bufferPos) {
        return new TrackNodeLocation(bufferPos);
    }

    private TrackNodeLocation(class_2338 readBlockPos) {
        super(readBlockPos.method_10263(), readBlockPos.method_10264(), readBlockPos.method_10260());
    }

    public class_243 getLocation() {
        return new class_243((double)this.method_10263() / 2.0, (double)this.method_10264() / 2.0 + (double)this.yOffsetPixels / 16.0, (double)this.method_10260() / 2.0);
    }

    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object pOther) {
        if (!this.equalsIgnoreDim(pOther)) return false;
        if (!(pOther instanceof TrackNodeLocation)) return false;
        TrackNodeLocation tnl = (TrackNodeLocation)((Object)pOther);
        if (!Objects.equals(tnl.dimension, this.dimension)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equalsIgnoreDim(Object pOther) {
        if (!super.equals(pOther)) return false;
        if (!(pOther instanceof TrackNodeLocation)) return false;
        TrackNodeLocation tnl = (TrackNodeLocation)((Object)pOther);
        if (tnl.yOffsetPixels != this.yOffsetPixels) return false;
        return true;
    }

    public int hashCode() {
        return (this.method_10264() + ((this.method_10260() + this.yOffsetPixels * 31) * 31 + this.dimension.hashCode()) * 31) * 31 + this.method_10263();
    }

    public class_2487 write(DimensionPalette dimensions) {
        class_2487 c = class_2512.method_10692((class_2338)new class_2338((class_2382)this));
        if (dimensions != null) {
            c.method_10569("D", dimensions.encode(this.dimension));
        }
        if (this.yOffsetPixels != 0) {
            c.method_10569("YO", this.yOffsetPixels);
        }
        return c;
    }

    public static TrackNodeLocation read(class_2487 tag, DimensionPalette dimensions) {
        TrackNodeLocation location = TrackNodeLocation.fromPackedPos(class_2512.method_10691((class_2487)tag));
        if (dimensions != null) {
            location.dimension = dimensions.decode(tag.method_10550("D"));
        }
        location.yOffsetPixels = tag.method_10550("YO");
        return location;
    }

    public void send(class_2540 buffer, DimensionPalette dimensions) {
        buffer.method_10804(this.method_10263());
        buffer.writeShort(this.method_10264());
        buffer.method_10804(this.method_10260());
        buffer.method_10804(this.yOffsetPixels);
        buffer.method_10804(dimensions.encode(this.dimension));
    }

    public static TrackNodeLocation receive(class_2540 buffer, DimensionPalette dimensions) {
        TrackNodeLocation location = TrackNodeLocation.fromPackedPos(new class_2338(buffer.method_10816(), (int)buffer.readShort(), buffer.method_10816()));
        location.yOffsetPixels = buffer.method_10816();
        location.dimension = dimensions.decode(buffer.method_10816());
        return location;
    }

    public Collection<class_2338> allAdjacent() {
        HashSet<class_2338> set = new HashSet<class_2338>();
        class_243 vec3 = this.getLocation().method_1023(0.0, (double)this.yOffsetPixels / 16.0, 0.0);
        double step = 0.125;
        for (int x : Iterate.positiveAndNegative) {
            for (int y : Iterate.positiveAndNegative) {
                for (int z : Iterate.positiveAndNegative) {
                    set.add(new class_2338(vec3.method_1031((double)x * step, (double)y * step, (double)z * step)));
                }
            }
        }
        return set;
    }

    public static class DiscoveredLocation
    extends TrackNodeLocation {
        BezierConnection turn = null;
        boolean forceNode = false;
        class_243 direction;
        class_243 normal;
        TrackMaterial materialA;
        TrackMaterial materialB;

        public DiscoveredLocation(class_1937 level, double x, double y, double z) {
            super(x, y, z);
            this.in(level);
        }

        public DiscoveredLocation(class_5321<class_1937> dimension, class_243 vec) {
            super(vec);
            this.in(dimension);
        }

        public DiscoveredLocation(class_1937 level, class_243 vec) {
            this((class_5321<class_1937>)level.method_27983(), vec);
        }

        public DiscoveredLocation materialA(TrackMaterial material) {
            this.materialA = material;
            return this;
        }

        public DiscoveredLocation materialB(TrackMaterial material) {
            this.materialB = material;
            return this;
        }

        public DiscoveredLocation materials(TrackMaterial materialA, TrackMaterial materialB) {
            this.materialA = materialA;
            this.materialB = materialB;
            return this;
        }

        public DiscoveredLocation viaTurn(BezierConnection turn) {
            this.turn = turn;
            if (turn != null) {
                this.forceNode();
            }
            return this;
        }

        public DiscoveredLocation forceNode() {
            this.forceNode = true;
            return this;
        }

        public DiscoveredLocation withNormal(class_243 normal) {
            this.normal = normal;
            return this;
        }

        public DiscoveredLocation withYOffset(int yOffsetPixels) {
            this.yOffsetPixels = yOffsetPixels;
            return this;
        }

        public DiscoveredLocation withDirection(class_243 direction) {
            this.direction = direction == null ? null : direction.method_1029();
            return this;
        }

        public boolean connectedViaTurn() {
            return this.turn != null;
        }

        public BezierConnection getTurn() {
            return this.turn;
        }

        public boolean shouldForceNode() {
            return this.forceNode;
        }

        public boolean differentMaterials() {
            return this.materialA != this.materialB;
        }

        public boolean notInLineWith(class_243 direction) {
            return this.direction != null && Math.max(direction.method_1026(this.direction), direction.method_1026(this.direction.method_1021(-1.0))) < 0.875;
        }

        public class_243 getDirection() {
            return this.direction;
        }
    }
}

