/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.filtering;

import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;

public class SidedFilteringBehaviour
extends FilteringBehaviour {
    Map<class_2350, FilteringBehaviour> sidedFilters;
    private BiFunction<class_2350, FilteringBehaviour, FilteringBehaviour> filterFactory;
    private Predicate<class_2350> validDirections;

    public SidedFilteringBehaviour(SmartBlockEntity be, ValueBoxTransform.Sided sidedSlot, BiFunction<class_2350, FilteringBehaviour, FilteringBehaviour> filterFactory, Predicate<class_2350> validDirections) {
        super(be, sidedSlot);
        this.filterFactory = filterFactory;
        this.validDirections = validDirections;
        this.sidedFilters = new IdentityHashMap<class_2350, FilteringBehaviour>();
        this.updateFilterPresence();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public FilteringBehaviour get(class_2350 side) {
        return this.sidedFilters.get(side);
    }

    public void updateFilterPresence() {
        HashSet<class_2350> valid = new HashSet<class_2350>();
        for (class_2350 d : Iterate.directions) {
            if (!this.validDirections.test(d)) continue;
            valid.add(d);
        }
        for (class_2350 d : Iterate.directions) {
            if (valid.contains(d)) {
                if (this.sidedFilters.containsKey(d)) continue;
                this.sidedFilters.put(d, this.filterFactory.apply(d, new FilteringBehaviour(this.blockEntity, this.slotPositioning)));
                continue;
            }
            if (!this.sidedFilters.containsKey(d)) continue;
            this.removeFilter(d);
        }
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        nbt.method_10566("Filters", (class_2520)NBTHelper.writeCompoundList(this.sidedFilters.entrySet(), entry -> {
            class_2487 compound = new class_2487();
            compound.method_10569("Side", ((class_2350)entry.getKey()).method_10146());
            ((FilteringBehaviour)entry.getValue()).write(compound, clientPacket);
            return compound;
        }));
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        NBTHelper.iterateCompoundList(nbt.method_10554("Filters", 10), compound -> {
            class_2350 face = class_2350.method_10143((int)compound.method_10550("Side"));
            if (this.sidedFilters.containsKey(face)) {
                this.sidedFilters.get(face).read((class_2487)compound, clientPacket);
            }
        });
        super.read(nbt, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        this.sidedFilters.values().forEach(BlockEntityBehaviour::tick);
    }

    @Override
    public boolean setFilter(class_2350 side, class_1799 stack) {
        if (!this.sidedFilters.containsKey(side)) {
            return true;
        }
        this.sidedFilters.get(side).setFilter(stack);
        return true;
    }

    @Override
    public class_1799 getFilter(class_2350 side) {
        if (!this.sidedFilters.containsKey(side)) {
            return class_1799.field_8037;
        }
        return this.sidedFilters.get(side).getFilter();
    }

    public boolean test(class_2350 side, class_1799 stack) {
        if (!this.sidedFilters.containsKey(side)) {
            return true;
        }
        return this.sidedFilters.get(side).test(stack);
    }

    @Override
    public void destroy() {
        this.sidedFilters.values().forEach(FilteringBehaviour::destroy);
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return this.sidedFilters.values().stream().reduce(ItemRequirement.NONE, (a, b) -> a.union(b.getRequiredItems()), (a, b) -> a.union((ItemRequirement)b));
    }

    public void removeFilter(class_2350 side) {
        if (!this.sidedFilters.containsKey(side)) {
            return;
        }
        this.sidedFilters.remove(side).destroy();
    }

    public boolean testHit(class_2350 direction, class_243 hit) {
        ValueBoxTransform.Sided sidedPositioning = (ValueBoxTransform.Sided)this.slotPositioning;
        class_2680 state = this.blockEntity.method_11010();
        class_243 localHit = hit.method_1020(class_243.method_24954((class_2382)this.blockEntity.method_11016()));
        return sidedPositioning.fromSide(direction).testHit(state, localHit);
    }
}

