/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.placement;

import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3965;

public class PlacementOffset {
    private final boolean success;
    private class_2382 pos;
    private Function<class_2680, class_2680> stateTransform;
    private class_2680 ghostState;

    private PlacementOffset(boolean success) {
        this.success = success;
        this.pos = class_2338.field_10980;
        this.stateTransform = Function.identity();
        this.ghostState = null;
    }

    public static PlacementOffset fail() {
        return new PlacementOffset(false);
    }

    public static PlacementOffset success() {
        return new PlacementOffset(true);
    }

    public static PlacementOffset success(class_2382 pos) {
        return PlacementOffset.success().at(pos);
    }

    public static PlacementOffset success(class_2382 pos, Function<class_2680, class_2680> transform) {
        return PlacementOffset.success().at(pos).withTransform(transform);
    }

    public PlacementOffset at(class_2382 pos) {
        this.pos = pos;
        return this;
    }

    public PlacementOffset withTransform(Function<class_2680, class_2680> stateTransform) {
        this.stateTransform = stateTransform;
        return this;
    }

    public PlacementOffset withGhostState(class_2680 ghostState) {
        this.ghostState = ghostState;
        return this;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public class_2382 getPos() {
        return this.pos;
    }

    public class_2338 getBlockPos() {
        if (this.pos instanceof class_2338) {
            return (class_2338)this.pos;
        }
        return new class_2338(this.pos);
    }

    public Function<class_2680, class_2680> getTransform() {
        return this.stateTransform;
    }

    public boolean hasGhostState() {
        return this.ghostState != null;
    }

    public class_2680 getGhostState() {
        return this.ghostState;
    }

    public boolean isReplaceable(class_1937 world) {
        if (!this.success) {
            return false;
        }
        return world.method_8320(new class_2338(this.pos)).method_26207().method_15800();
    }

    public class_1269 placeInWorld(class_1937 world, class_1747 blockItem, class_1657 player, class_1268 hand, class_3965 ray) {
        if (!this.isReplaceable(world)) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_1838 context = new class_1838(player, hand, ray);
        class_2338 newPos = new class_2338(this.pos);
        class_1799 stackBefore = player.method_5998(hand).method_7972();
        if (!world.method_8505(player, newPos)) {
            return class_1269.field_5811;
        }
        class_2680 state = this.stateTransform.apply(blockItem.method_7711().method_9564());
        if (state.method_28498((class_2769)class_2741.field_12508)) {
            class_3610 fluidState = world.method_8316(newPos);
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        world.method_8501(newPos, state);
        class_2680 newState = world.method_8320(newPos);
        class_2498 soundtype = newState.method_26231();
        world.method_8396(null, newPos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
        player.method_7259(class_3468.field_15372.method_14956((Object)blockItem));
        newState.method_26204().method_9567(world, newPos, newState, (class_1309)player, stackBefore);
        if (player instanceof class_3222) {
            class_174.field_1191.method_9087((class_3222)player, newPos, context.method_8041());
        }
        if (!player.method_7337()) {
            context.method_8041().method_7934(1);
        }
        return class_1269.field_5812;
    }
}

